/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.enums.NetType;
import xyz.pixelatedw.mineminenomi.effects.CaughtInNetEffect;
import xyz.pixelatedw.mineminenomi.entities.NetEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.packets.server.SToggleAnimationPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class NetItem
extends Item {
    private static final int COOLDOWN = 200;
    private static final int USE_TIME = 20;
    private Supplier<CaughtInNetEffect> netEffect;

    public NetItem(Supplier<CaughtInNetEffect> handcuffed) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.MISC).func_200917_a(1));
        this.netEffect = handcuffed;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation((LivingEntity)player, ModAnimations.CHARGE_NET_THROW, this.func_77626_a(itemstack), true), (LivingEntity)player);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!world.field_72995_K) {
                WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation((LivingEntity)player, ModAnimations.CHARGE_NET_THROW), (LivingEntity)player);
                int useTime = this.func_77626_a(stack) - timeLeft;
                if (useTime < 20) {
                    return;
                }
                this.throwNet((LivingEntity)player, world, stack);
            }
        }
    }

    public void func_219972_a(World world, LivingEntity entity, ItemStack stack, int count) {
        int useTime;
        if (world.field_72995_K && (useTime = this.func_77626_a(stack) - entity.func_184605_cv()) >= 20) {
            Minecraft.func_71410_x().field_71460_t.field_78516_c.func_187460_a(Hand.MAIN_HAND);
        }
    }

    private void throwNet(LivingEntity entity, World world, ItemStack stack) {
        NetEntity netEntity = NetEntity.createFromItem(world, entity, this);
        netEntity.func_70107_b(entity.func_226277_ct_(), entity.func_226280_cw_() + 1.0, entity.func_226281_cx_());
        netEntity.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 1.25f, 0.0f);
        world.func_217376_c((Entity)netEntity);
        boolean removeItem = true;
        if (entity instanceof PlayerEntity) {
            this.startCooldowns(((PlayerEntity)entity).func_184811_cZ());
            boolean bl = removeItem = !((PlayerEntity)entity).field_71075_bZ.field_75098_d;
        }
        if (removeItem) {
            stack.func_190918_g(1);
        }
    }

    private void startCooldowns(CooldownTracker cooldown) {
        cooldown.func_185145_a((Item)ModItems.ROPE_NET.get(), 200);
        cooldown.func_185145_a((Item)ModItems.KAIROSEKI_NET.get(), 200);
    }

    public CaughtInNetEffect getEffect() {
        return this.netEffect.get();
    }

    public NetType getNetType() {
        return this.getEffect().getType();
    }

    public int func_77626_a(ItemStack pStack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack pStack) {
        return UseAction.NONE;
    }
}

