/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.events.CrewEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModFoods;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class SakeCupItem
extends Item {
    public SakeCupItem() {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.MISC).func_200917_a(1).func_221540_a(ModFoods.ALCOHOL));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.getLeader(player.func_184614_ca(), world) != null) {
            player.func_184598_c(hand);
        } else {
            int slot = WyHelper.getIndexOfItemStack((Item)ModItems.SAKE_BOTTLE.get(), (IInventory)player.field_71071_by);
            if (slot >= 0) {
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                stack.func_222118_a(1, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
                this.setLeader(player.func_184614_ca(), player);
                return ActionResult.func_226248_a_((Object)itemstack);
            }
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity entity) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            PlayerEntity leader = this.getLeader(itemStack, player.field_70170_p);
            if (leader != null) {
                ExtendedWorldData worldProps = ExtendedWorldData.get();
                Crew crew = worldProps.getCrewWithCaptain(leader.func_110124_au());
                if (crew == null) {
                    WyDebug.debug("Cannot find a crew for captain " + leader.func_200200_C_().getString());
                } else {
                    CrewEvent.Join event = new CrewEvent.Join(player, crew);
                    if (!MinecraftForge.EVENT_BUS.post((Event)event) && !crew.hasMember(player.func_110124_au())) {
                        worldProps.addCrewMember(crew, (LivingEntity)player);
                        FactionHelper.sendMessageToCrew(world, crew, (ITextComponent)new TranslationTextComponent(ModI18n.CREW_MESSAGE_NEW_JOIN, new Object[]{player.func_200200_C_().getString()}));
                        IEntityStats props = EntityStatsCapability.get(entity);
                        props.setFaction("pirate");
                        WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(player.func_145782_y(), props), (LivingEntity)player);
                        itemStack.func_196082_o().func_74768_a("leader", 0);
                    }
                }
            }
            player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.SAKE_CUP.get()));
            itemStack.func_190918_g(1);
        }
        return itemStack;
    }

    public void setLeader(ItemStack itemStack, PlayerEntity leader) {
        itemStack.func_77982_d(new CompoundNBT());
        itemStack.func_77978_p().func_74778_a("leader", leader.func_110124_au().toString());
    }

    public PlayerEntity getLeader(ItemStack itemStack, World world) {
        String leaderUUID;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new CompoundNBT());
        }
        if (!Strings.isNullOrEmpty((String)(leaderUUID = itemStack.func_77978_p().func_74779_i("leader")))) {
            return world.func_217371_b(UUID.fromString(leaderUUID));
        }
        return null;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }
}

