/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.armors;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.models.armors.ColaBackpackModel;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ColaBackpackItem
extends ArmorItem {
    private static final int COLA_REFILL_TICKS = 20;

    public ColaBackpackItem() {
        super((IArmorMaterial)ModArmors.COLA_BACKPACK_MATERIAL, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(ModCreativeTabs.EQUIPMENT));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        ColaBackpackModel armorModel = new ColaBackpackModel();
        return (A)((Object)armorModel);
    }

    @Nullable
    public String getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlotType slot, String type) {
        return String.format("%s:textures/models/armor/cola_backpack.png", "mineminenomi");
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.isCyborg() && player.field_70173_aa % 20 == 0) {
            int colaSlot = this.getColaSlot(player);
            int ultraColaSlot = this.getUltraColaSlot(player);
            if (colaSlot != -1 && props.getMaxCola() > props.getCola()) {
                props.alterCola(25);
                player.field_71071_by.func_70298_a(colaSlot, 1);
                WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)((ServerPlayerEntity)player));
            } else if (ultraColaSlot != -1 && props.getMaxCola() > props.getCola()) {
                props.alterCola(100);
                player.field_71071_by.func_70298_a(ultraColaSlot, 1);
                WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)((ServerPlayerEntity)player));
            }
        }
    }

    public int getColaSlot(PlayerEntity player) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.COLA.get()))) {
            return -1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.COLA.get()) continue;
            return i;
        }
        return -1;
    }

    public int getUltraColaSlot(PlayerEntity player) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.ULTRA_COLA.get()))) {
            return -1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.ULTRA_COLA.get()) continue;
            return i;
        }
        return -1;
    }
}

