/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.weapons;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;

public class ClimaTactItem
extends Item {
    private int damage = 1;
    private int level = 1;
    private Ingredient repairIngredient;

    public ClimaTactItem(int damage, int level, int maxDamage) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200918_c(maxDamage));
        this.damage = damage;
        this.level = level;
    }

    public WeatherBallKind[] checkCharge(ItemStack itemStack) {
        byte[] charge = itemStack.func_196082_o().func_74770_j("charge");
        WeatherBallKind[] tempo = new WeatherBallKind[charge.length];
        for (int i = 0; i < charge.length; ++i) {
            byte b = charge[i];
            if (b == 0) {
                return new WeatherBallKind[0];
            }
            tempo[i] = WeatherBallKind.from(b);
        }
        return tempo;
    }

    public void chargeWeatherBall(ItemStack itemStack, WeatherBallKind ball) {
        CompoundNBT nbt = itemStack.func_196082_o();
        if (!nbt.func_74764_b("charge")) {
            nbt.func_74773_a("charge", new byte[3]);
        }
        byte[] charge = nbt.func_74770_j("charge");
        for (int i = 0; i < 3; ++i) {
            if (charge[i] != 0) continue;
            charge[i] = ball.getKind();
            break;
        }
        nbt.func_74773_a("charge", charge);
    }

    public void chargeWeatherBall(ItemStack itemStack, String ball) {
        if (Strings.isNullOrEmpty((String)itemStack.func_196082_o().func_74779_i("firstSlot"))) {
            itemStack.func_196082_o().func_74778_a("firstSlot", ball);
        } else if (Strings.isNullOrEmpty((String)itemStack.func_196082_o().func_74779_i("secondSlot"))) {
            itemStack.func_196082_o().func_74778_a("secondSlot", ball);
        } else if (Strings.isNullOrEmpty((String)itemStack.func_196082_o().func_74779_i("thirdSlot"))) {
            itemStack.func_196082_o().func_74778_a("thirdSlot", ball);
        }
    }

    public void emptyCharge(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_196082_o();
        nbt.func_74773_a("charge", new byte[3]);
        itemStack.func_196082_o().func_74778_a("firstSlot", "");
        itemStack.func_196082_o().func_74778_a("secondSlot", "");
        itemStack.func_196082_o().func_74778_a("thirdSlot", "");
    }

    public static void setDamageModifier(ItemStack stack, double multiplier) {
        stack.func_196082_o().func_74780_a("multiplier", multiplier);
    }

    public void setCharged(ItemStack stack, boolean flag) {
        stack.func_196082_o().func_74757_a("isCharged", flag);
    }

    public boolean isCharged(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("isCharged");
    }

    public int getLevel() {
        return this.level;
    }

    public <T extends ClimaTactItem> T setRepairIngredient(Ingredient ingredient) {
        this.repairIngredient = ingredient;
        return (T)((Object)this);
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient;
    }

    public void func_77663_a(ItemStack stack, World level, Entity entity, int itemSlot, boolean isSelected) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            double multiplier = stack.func_196082_o().func_74769_h("multiplier");
            if (multiplier <= 0.0) {
                multiplier = 1.0;
            }
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.damage * multiplier, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Speed modifier", -2.8, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.repairIngredient.test(repair) || super.func_82789_a(toRepair, repair);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT nbt = itemStack.func_196082_o();
        byte[] charge = nbt.func_74764_b("charge") ? itemStack.func_196082_o().func_74770_j("charge") : new byte[3];
        String[] tempoColors = new String[charge.length];
        block5: for (int i = 0; i < charge.length; ++i) {
            byte b = charge[i];
            if (WeatherBallKind.from(b) == null) {
                tempoColors[i] = "\u00a7r";
                continue;
            }
            switch (WeatherBallKind.from(b)) {
                case COOL: {
                    tempoColors[i] = "\u00a7b";
                    continue block5;
                }
                case HEAT: {
                    tempoColors[i] = "\u00a74";
                    continue block5;
                }
                case THUNDER: {
                    tempoColors[i] = "\u00a7e";
                    continue block5;
                }
                default: {
                    tempoColors[i] = "\u00a7r";
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        int maxCharges = charge.length;
        for (int i = 0; i < maxCharges; ++i) {
            sb.append(String.format("%s\u2588\u00a7r", tempoColors[i]));
            if (i >= maxCharges - 1) continue;
            sb.append("\u2501");
        }
        tooltip.add((ITextComponent)new StringTextComponent(sb.toString()));
    }
}

