/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.weapons;

import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityItemTier;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;

public class ModSwordItem
extends SwordItem {
    public double damage = 1.0;
    public double range = 0.0;
    protected boolean isPoisonous = false;
    protected boolean isFireAspect = false;
    protected boolean isSlownessInducing = false;
    protected boolean isStackable = false;
    protected int poisonTimer = 100;
    protected int fireAspectTimer = 10;
    protected int slownessTimer = 100;
    protected int frostBiteTimer = 0;
    private boolean isBlunt = false;
    private boolean rustImmunity = false;
    private boolean independentImbuing = false;
    private Ingredient repairIngredient;
    protected static final UUID ATTACK_RANGE_MODIFIER = UUID.fromString("06256896-00c1-45b4-bc71-514ee36310bd");

    public ModSwordItem(Item.Properties props, int damage, float attackSpeed) {
        super((IItemTier)AbilityItemTier.WEAPON, damage, attackSpeed, props);
        this.damage = damage - 1;
    }

    public ModSwordItem(int damage, int durability) {
        this(damage, -2.4f, durability);
        this.damage = damage - 1;
    }

    public ModSwordItem(int damage, float attackSpeed, int durability) {
        super((IItemTier)AbilityItemTier.WEAPON, damage, attackSpeed, new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200915_b(durability));
        this.damage = damage - 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.WEAPON || enchantment.field_77351_y == EnchantmentType.BREAKABLE;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (!world.field_72995_K) {
            CompoundNBT nbt = itemStack.func_196082_o();
            if (nbt.func_74767_n("isClone") && !nbt.func_74767_n("hasCloneTag")) {
                itemStack.func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + itemStack.func_200301_q().getString() + " (Replica)"));
                nbt.func_74757_a("hasCloneTag", true);
            } else if (!nbt.func_74764_b("isClone")) {
                nbt.func_74757_a("isClone", false);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public int func_77619_b() {
        return 14;
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        boolean hasBusoHaki;
        IAbilityData abilityProps = AbilityDataCapability.get(attacker);
        BusoshokuHakiImbuingAbility ability = abilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        boolean bl = hasBusoHaki = ability != null && ability.isContinuous();
        if (!hasBusoHaki) {
            int damage = itemStack.func_196082_o().func_74767_n("isClone") ? 3 : 1;
            itemStack.func_222118_a(damage, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        if (hasBusoHaki || this.isBlunt) {
            Item mainShield = target.func_184614_ca().func_77973_b();
            Item secondaryShield = target.func_184592_cb().func_77973_b();
            if (target instanceof PlayerEntity && Math.random() > 0.5 && (mainShield.equals(Items.field_185159_cQ) || secondaryShield.equals(Items.field_185159_cQ))) {
                ((PlayerEntity)target).func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                target.func_184602_cy();
                target.field_70170_p.func_72960_a((Entity)target, (byte)30);
            }
        }
        if (this.isPoisonous) {
            target.func_195064_c(new EffectInstance(Effects.field_76436_u, this.poisonTimer, 0));
        }
        if (this.isFireAspect) {
            AbilityHelper.setSecondsOnFireBy((Entity)target, this.fireAspectTimer, attacker);
        }
        if (this.isSlownessInducing) {
            if (this.isStackable) {
                if (target.func_70644_a(Effects.field_76421_d)) {
                    int timer = target.func_70660_b(Effects.field_76421_d).func_76459_b();
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, timer + this.slownessTimer, 0));
                } else {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, this.slownessTimer, 0));
                }
            } else {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, this.slownessTimer, 0));
            }
        }
        if (this.frostBiteTimer > 0) {
            AbilityHelper.addFrostbiteStacks(target, attacker, 1);
        }
        return true;
    }

    public <T extends ModSwordItem> T setIsPoisonous() {
        this.isPoisonous = true;
        this.poisonTimer = 100;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setIsPoisonous(int timer) {
        this.isPoisonous = true;
        this.poisonTimer = timer;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setRepairIngredient(Ingredient ingredient) {
        this.repairIngredient = ingredient;
        return (T)((Object)this);
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient;
    }

    public <T extends ModSwordItem> T setBlunt() {
        this.isBlunt = true;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setSharp() {
        this.isBlunt = false;
        return (T)((Object)this);
    }

    public boolean isBlunt() {
        return this.isBlunt;
    }

    public <T extends ModSwordItem> T setRustImmunity() {
        this.rustImmunity = true;
        return (T)((Object)this);
    }

    @Deprecated
    public boolean isRustImmune() {
        return this.rustImmunity;
    }

    public <T extends ModSwordItem> T setIsFireAspect() {
        this.isFireAspect = true;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setIsFireAspect(int timer) {
        this.isFireAspect = true;
        this.fireAspectTimer = timer;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setIsSlownessInducing() {
        this.isSlownessInducing = true;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setIsSlownessInducing(int timer) {
        this.isSlownessInducing = true;
        this.slownessTimer = timer;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setFrosbiteTimer(int timer) {
        this.frostBiteTimer = timer;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setIsSlownessInducing(int timer, boolean isStackable) {
        this.isSlownessInducing = true;
        this.slownessTimer = timer;
        this.isStackable = isStackable;
        return (T)((Object)this);
    }

    public <T extends ModSwordItem> T setExtraAttackRange(double range) {
        this.range = range;
        return (T)((Object)this);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        try {
            return this.repairIngredient.test(repair);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean usesIndependentImbuing() {
        return this.independentImbuing;
    }

    public void setIndependentImbuing() {
        this.independentImbuing = true;
    }
}

