/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins;

import com.google.common.base.Strings;
import java.util.Map;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import xyz.pixelatedw.mineminenomi.api.events.PotionAfterAddedEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingAttackEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingDamageEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingHurtEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    private static final Logger WLOGGER = LogManager.getLogger();
    private WyLivingAttackEvent livingAttackEvent;

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        this.livingAttackEvent = new WyLivingAttackEvent(entity, pSource, pAmount);
        if (entity instanceof PlayerEntity) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)this.livingAttackEvent);
        if (this.livingAttackEvent.isCanceled()) {
            cir.cancel();
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), ordinal=0)
    public DamageSource hurtDamageSource(DamageSource pSource) {
        return this.livingAttackEvent.getSource();
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), ordinal=0)
    public float hurtAmount(float pAmount) {
        return this.livingAttackEvent.getAmount();
    }

    @ModifyArgs(method={"actuallyHurt"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;onLivingHurt(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/util/DamageSource;F)F", remap=false))
    public void actuallyHurtOnLivingHurt(Args args) {
        LivingEntity entity = (LivingEntity)args.get(0);
        DamageSource damageSource = (DamageSource)args.get(1);
        float amount = ((Float)args.get(2)).floatValue();
        WyLivingHurtEvent event = new WyLivingHurtEvent(entity, damageSource, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (Float.isNaN(event.getAmount())) {
            WLOGGER.warn("NaN value received in hurt event, original value was " + amount);
            return;
        }
        if (!event.isCanceled()) {
            args.set(1, (Object)event.getSource());
            args.set(2, (Object)Float.valueOf(event.getAmount()));
        } else {
            args.set(2, (Object)Float.valueOf(0.0f));
        }
    }

    @ModifyArgs(method={"actuallyHurt"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;onLivingDamage(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/util/DamageSource;F)F", remap=false))
    public void actuallyHurtOnLivingDamage(Args args) {
        LivingEntity entity = (LivingEntity)args.get(0);
        DamageSource damageSource = (DamageSource)args.get(1);
        float amount = ((Float)args.get(2)).floatValue();
        WyLivingDamageEvent event = new WyLivingDamageEvent(entity, damageSource, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (Float.isNaN(event.getAmount())) {
            WLOGGER.warn("NaN value received in hurt event, original value was " + amount);
            return;
        }
        if (!event.isCanceled()) {
            args.set(1, (Object)event.getSource());
            args.set(2, (Object)Float.valueOf(event.getAmount()));
        } else {
            args.set(2, (Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    public void dropAllDeathLoot(DamageSource pDamageSource, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (WyHelper.isInChallengeDimension(entity.field_70170_p)) {
            ci.cancel();
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSize(Pose pose, CallbackInfoReturnable<EntitySize> callback) {
        LivingEntity living = (LivingEntity)this;
        IDevilFruit props = DevilFruitCapability.get(living);
        if (!Strings.isNullOrEmpty((String)props.getZoanPoint())) {
            MorphInfo info = MorphHelper.getZoanInfo(living);
            if (info == null) {
                return;
            }
            Map<Pose, EntitySize> poses = info.getSizes();
            if (poses != null && poses.containsKey(living.func_213283_Z()) && poses.get(living.func_213283_Z()) != null) {
                callback.setReturnValue((Object)poses.get(living.func_213283_Z()));
            }
        }
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="HEAD")})
    public void fireAfterEffectAddedEvent(EffectInstance instance, CallbackInfo callback) {
        LivingEntity living = (LivingEntity)this;
        PotionAfterAddedEvent event = new PotionAfterAddedEvent(living, instance);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }
}

