/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.models.entities.mobs.animals;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.BigDuckEntity;

public class BigDuckModel<T extends BigDuckEntity>
extends BipedModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer leftWing;
    private final ModelRenderer rightWing;
    private final ModelRenderer tail;
    private final ModelRenderer leftLeg;
    private final ModelRenderer lowerLeftLeg;
    private final ModelRenderer leftFoot;
    private final ModelRenderer rightLeg;
    private final ModelRenderer lowerRightLeg;
    private final ModelRenderer rightFoot;
    private final ModelRenderer head;
    private final ModelRenderer neck;
    private final ModelRenderer mainHead;
    private final ModelRenderer upperBeak;
    private final ModelRenderer lowerBeak;
    protected float quackAnimationProgress;

    public BigDuckModel() {
        super(1.0f);
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 6.4042f, 7.8958f);
        this.body.func_78784_a(64, 30).func_228303_a_(-7.0f, -5.4042f, -14.8958f, 14.0f, 11.0f, 18.0f, 0.0f, false);
        this.body.func_78784_a(60, 61).func_228303_a_(-6.5f, -3.6542f, -12.3958f, 13.0f, 10.0f, 15.0f, 0.0f, false);
        this.body.func_78784_a(72, 0).func_228303_a_(-5.5f, -5.9542f, -15.6458f, 11.0f, 11.0f, 17.0f, 0.0f, false);
        this.body.func_78784_a(61, 89).func_228303_a_(-6.0f, -4.7042f, 2.6042f, 12.0f, 10.0f, 3.0f, 0.0f, false);
        this.body.func_78784_a(61, 104).func_228303_a_(-5.0f, -4.4042f, 5.6042f, 10.0f, 8.0f, 2.0f, 0.0f, false);
        this.leftWing = new ModelRenderer((Model)this);
        this.leftWing.func_78793_a(6.5f, -2.9042f, -11.8958f);
        this.body.func_78792_a(this.leftWing);
        this.setRotationAngle(this.leftWing, -0.2182f, 0.0f, 0.0f);
        this.leftWing.func_78784_a(8, 72).func_228303_a_(0.5f, -2.4526f, -2.2454f, 1.0f, 9.0f, 13.0f, 0.0f, true);
        this.leftWing.func_78784_a(0, 84).func_228303_a_(0.5f, -2.4526f, 10.7546f, 1.0f, 8.0f, 2.0f, 0.0f, true);
        this.rightWing = new ModelRenderer((Model)this);
        this.rightWing.func_78793_a(-6.5f, -2.9042f, -11.8958f);
        this.body.func_78792_a(this.rightWing);
        this.setRotationAngle(this.rightWing, -0.2182f, 0.0f, 0.0f);
        this.rightWing.func_78784_a(8, 72).func_228303_a_(-1.5f, -2.5f, -1.8125f, 1.0f, 9.0f, 13.0f, 0.0f, false);
        this.rightWing.func_78784_a(0, 84).func_228303_a_(-1.5f, -2.5f, 11.1875f, 1.0f, 8.0f, 2.0f, 0.0f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, -4.3853f, 7.3423f);
        this.body.func_78792_a(this.tail);
        this.setRotationAngle(this.tail, -0.1309f, 0.0f, 0.0f);
        this.tail.func_78784_a(53, 116).func_228303_a_(-5.0f, 0.1937f, 0.0119f, 10.0f, 0.0f, 10.0f, 0.0f, false);
        this.leftLeg = new ModelRenderer((Model)this);
        this.leftLeg.func_78793_a(2.5f, 11.3125f, 3.0f);
        this.leftLeg.func_78784_a(16, 97).func_228303_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, true);
        this.lowerLeftLeg = new ModelRenderer((Model)this);
        this.lowerLeftLeg.func_78793_a(0.0f, 6.0f, 0.0f);
        this.leftLeg.func_78792_a(this.lowerLeftLeg);
        this.lowerLeftLeg.func_78784_a(16, 107).func_228303_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, true);
        this.leftFoot = new ModelRenderer((Model)this);
        this.leftFoot.func_78793_a(0.0f, 5.6875f, 0.0f);
        this.lowerLeftLeg.func_78792_a(this.leftFoot);
        this.leftFoot.func_78784_a(-7, 114).func_228303_a_(-2.5f, 1.0f, -7.0f, 5.0f, 0.0f, 8.0f, 0.0f, true);
        this.leftFoot.func_78784_a(13, 117).func_228303_a_(-1.5f, 0.0f, -3.0f, 3.0f, 1.0f, 4.0f, 0.0f, true);
        this.rightLeg = new ModelRenderer((Model)this);
        this.rightLeg.func_78793_a(-2.5f, 11.3125f, 3.0f);
        this.rightLeg.func_78784_a(16, 97).func_228303_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.lowerRightLeg = new ModelRenderer((Model)this);
        this.lowerRightLeg.func_78793_a(0.0f, 6.0f, 0.0f);
        this.rightLeg.func_78792_a(this.lowerRightLeg);
        this.lowerRightLeg.func_78784_a(16, 107).func_228303_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.rightFoot = new ModelRenderer((Model)this);
        this.rightFoot.func_78793_a(0.0f, 5.9375f, 0.0625f);
        this.lowerRightLeg.func_78792_a(this.rightFoot);
        this.rightFoot.func_78784_a(13, 117).func_228303_a_(-1.5f, -0.25f, -3.0625f, 3.0f, 1.0f, 4.0f, 0.0f, false);
        this.rightFoot.func_78784_a(-7, 114).func_228303_a_(-2.5f, 0.75f, -7.0625f, 5.0f, 0.0f, 8.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(-0.0789f, 0.1837f, -4.0f);
        this.neck = new ModelRenderer((Model)this);
        this.neck.func_78793_a(3.0f, 0.0f, 1.0f);
        this.head.func_78792_a(this.neck);
        this.setRotationAngle(this.neck, 0.4363f, 0.0f, 0.0f);
        this.neck.func_78784_a(38, 25).func_228303_a_(-6.9211f, -4.61f, -4.4195f, 8.0f, 11.0f, 7.0f, 0.0f, false);
        this.mainHead = new ModelRenderer((Model)this);
        this.mainHead.func_78793_a(0.0789f, -2.9837f, -0.5f);
        this.head.func_78792_a(this.mainHead);
        this.mainHead.func_78784_a(0, 0).func_228303_a_(-5.5f, -8.5f, -9.0f, 11.0f, 11.0f, 12.0f, 0.0f, false);
        this.upperBeak = new ModelRenderer((Model)this);
        this.upperBeak.func_78793_a(0.0f, -2.0f, -9.0f);
        this.mainHead.func_78792_a(this.upperBeak);
        this.upperBeak.func_78784_a(0, 24).func_228303_a_(-5.0f, -1.5f, -5.0f, 10.0f, 3.0f, 6.0f, 0.0f, false);
        this.upperBeak.func_78784_a(0, 35).func_228303_a_(-5.5f, -1.5f, -11.0f, 11.0f, 3.0f, 6.0f, 0.0f, false);
        this.lowerBeak = new ModelRenderer((Model)this);
        this.lowerBeak.func_78793_a(0.0f, 0.5f, -8.0f);
        this.mainHead.func_78792_a(this.lowerBeak);
        this.lowerBeak.func_78784_a(0, 46).func_228303_a_(-4.5f, -1.0f, -11.5f, 9.0f, 2.0f, 11.0f, 0.0f, false);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.quackAnimationProgress = ((BigDuckEntity)((Object)entity)).getQuackAnimationProgress(partialTicks);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        if (this.quackAnimationProgress < 1.0f) {
            this.upperBeak.field_78795_f = -MathHelper.func_76126_a((float)(this.quackAnimationProgress * 2.0f * (float)Math.PI)) * 0.5f;
            this.upperBeak.field_78795_f = Math.min(this.upperBeak.field_78795_f, 0.0f);
            this.lowerBeak.field_78795_f = MathHelper.func_76126_a((float)(this.quackAnimationProgress * 2.0f * (float)Math.PI)) * 0.5f;
            this.lowerBeak.field_78795_f = Math.max(this.lowerBeak.field_78795_f, 0.0f);
        } else {
            this.upperBeak.field_78795_f = 0.0f;
            this.lowerBeak.field_78795_f = 0.0f;
        }
        Vector3d vector3d = entity.func_213322_ci();
        if (!entity.func_233570_aj_() && vector3d.field_72448_b < 0.0) {
            this.leftWing.field_78795_f = (float)Math.toRadians(75.0);
            this.leftWing.field_78808_h = (float)Math.toRadians(75.0) + (float)(Math.sin(ageInTicks * 0.75f) * (double)0.9f);
            this.rightWing.field_78795_f = (float)Math.toRadians(75.0);
            this.rightWing.field_78808_h = -((float)Math.toRadians(75.0)) - (float)(Math.sin(ageInTicks * 0.75f) * (double)0.9f);
            this.tail.field_78795_f = (float)(Math.sin(ageInTicks * 1.2f) * (double)0.4f);
        } else {
            this.leftWing.field_78795_f = 0.0f;
            this.leftWing.field_78796_g = 0.0f;
            this.leftWing.field_78808_h = 0.0f;
            this.rightWing.field_78795_f = 0.0f;
            this.rightWing.field_78796_g = 0.0f;
            this.rightWing.field_78808_h = 0.0f;
            float f = 1.0f;
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6f)) * 1.5f * limbSwingAmount / f;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6f + (float)Math.PI)) * 1.5f * limbSwingAmount / f;
            float tailSpeed = 0.2f;
            if (((BigDuckEntity)((Object)entity)).func_184179_bs() != null && ((BigDuckEntity)((Object)entity)).func_184179_bs().func_70051_ag()) {
                tailSpeed = 0.6f;
                this.leftWing.field_78808_h = (float)Math.toRadians(55.0);
                this.leftWing.field_78795_f = (float)(Math.sin(ageInTicks * 0.15f) * (double)0.05f);
                this.leftWing.field_78796_g = (float)Math.toRadians(25.0);
                this.rightWing.field_78808_h = (float)Math.toRadians(-55.0);
                this.rightWing.field_78795_f = (float)(Math.sin(ageInTicks * 0.15f) * (double)0.05f);
                this.rightWing.field_78796_g = (float)Math.toRadians(-25.0);
            }
            this.tail.field_78795_f = (float)(Math.sin(ageInTicks * tailSpeed) * (double)0.1f);
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.field_217114_e) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        }
        this.body.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

