/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SChangeCombatBarPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CChangeCombatBarPacket {
    private int dir = 0;
    private int amount = 1;
    private int clientMaxBars;

    public CChangeCombatBarPacket() {
    }

    public CChangeCombatBarPacket(int dir) {
        this.dir = dir;
        this.amount = 1;
    }

    public CChangeCombatBarPacket(int dir, int amount, int clientMaxBars) {
        this.dir = dir;
        this.amount = amount;
        this.clientMaxBars = clientMaxBars;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.dir);
        buffer.writeInt(this.amount);
        buffer.writeInt(this.clientMaxBars);
    }

    public static CChangeCombatBarPacket decode(PacketBuffer buffer) {
        CChangeCombatBarPacket msg = new CChangeCombatBarPacket();
        msg.dir = buffer.readInt();
        msg.amount = buffer.readInt();
        msg.clientMaxBars = buffer.readInt();
        return msg;
    }

    public static void handle(CChangeCombatBarPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
                int maxBars = Math.min(message.clientMaxBars, CommonConfig.INSTANCE.getAbilityBars());
                int amount = Math.min(message.amount, maxBars);
                if (message.dir == 0) {
                    if (abilityProps.getCombatBarSet() + amount < maxBars) {
                        abilityProps.nextCombatBarSet(amount);
                    } else {
                        abilityProps.setCombatBarSet(0);
                    }
                } else if (abilityProps.getCombatBarSet() - amount >= 0) {
                    abilityProps.prevCombatBarSet(amount);
                } else if (maxBars == amount) {
                    abilityProps.setCombatBarSet(0);
                } else {
                    int barsOnLastPage = 0;
                    for (int i = maxBars; i > 0; i -= amount) {
                        barsOnLastPage = i;
                    }
                    abilityProps.setCombatBarSet(maxBars - barsOnLastPage);
                }
                WyNetwork.sendTo(new SChangeCombatBarPacket(abilityProps.getCombatBarSet()), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

