/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SEquipAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CEquipAbilityPacket {
    private int slot;
    private ResourceLocation abilityId;

    public CEquipAbilityPacket() {
    }

    public CEquipAbilityPacket(int id, AbilityCore core) {
        this.slot = id;
        this.abilityId = core.getRegistryName();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
        buffer.func_192572_a(this.abilityId);
    }

    public static CEquipAbilityPacket decode(PacketBuffer buffer) {
        CEquipAbilityPacket msg = new CEquipAbilityPacket();
        msg.slot = buffer.readInt();
        msg.abilityId = buffer.func_192575_l();
        return msg;
    }

    public static void handle(CEquipAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                try {
                    AbilityCore core;
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player == null) {
                        return;
                    }
                    IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
                    Ability oldAbility = (Ability)abilityDataProps.getEquippedAbility(message.slot);
                    if (oldAbility != null) {
                        if (oldAbility.hasComponent(ModAbilityKeys.COOLDOWN) && oldAbility.getComponent(ModAbilityKeys.COOLDOWN).get().isOnCooldown()) {
                            return;
                        }
                        if (oldAbility.hasComponent(ModAbilityKeys.DISABLE) && oldAbility.getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
                            return;
                        }
                        if (oldAbility.hasComponent(ModAbilityKeys.CONTINUOUS) && oldAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
                            return;
                        }
                        if (oldAbility.hasComponent(ModAbilityKeys.CHARGE) && oldAbility.getComponent(ModAbilityKeys.CHARGE).get().isCharging()) {
                            return;
                        }
                    }
                    if ((core = (AbilityCore)ModRegistries.ABILITIES.getValue(message.abilityId)) == null) {
                        return;
                    }
                    if (!abilityDataProps.hasUnlockedAbility(core)) {
                        return;
                    }
                    Object ability = core.createAbility();
                    abilityDataProps.setEquippedAbility(message.slot, (IAbility)ability);
                    WyNetwork.sendToAllTrackingAndSelf(new SEquipAbilityPacket(player.func_145782_y(), message.slot, core), (LivingEntity)player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

