/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateHakiColorPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CSetHakiColorPacket {
    private int color;

    public CSetHakiColorPacket() {
    }

    public CSetHakiColorPacket(int color) {
        this.color = color;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.color);
    }

    public static CSetHakiColorPacket decode(PacketBuffer buffer) {
        CSetHakiColorPacket msg = new CSetHakiColorPacket();
        msg.color = buffer.readInt();
        return msg;
    }

    public static void handle(CSetHakiColorPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IHakiData props = HakiDataCapability.get((LivingEntity)player);
                props.setHaoshokuHakiColour(message.color);
                WyNetwork.sendToAllTracking(new SUpdateHakiColorPacket(player.func_145782_y(), message.color), (LivingEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

