/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.abilities.doa.AirDoorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility;
import xyz.pixelatedw.mineminenomi.api.events.ability.AbilityCanUseEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.events.passives.DoaPassiveEvents;

public class CUseAbilityPacket {
    private int slot;

    public CUseAbilityPacket() {
    }

    public CUseAbilityPacket(int slot) {
        this.slot = slot;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
    }

    public static CUseAbilityPacket decode(PacketBuffer buffer) {
        CUseAbilityPacket msg = new CUseAbilityPacket();
        msg.slot = buffer.readInt();
        return msg;
    }

    public static void handle(CUseAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                player.field_70170_p.func_217381_Z().func_76320_a("abilityUse");
                IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
                Ability abl = (Ability)abilityDataProps.getEquippedAbility(message.slot);
                AbilityCanUseEvent pre = new AbilityCanUseEvent((PlayerEntity)player, abl);
                if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                    return;
                }
                if (abl == null || player.func_175149_v()) {
                    return;
                }
                if (message.slot > 8 * CommonConfig.INSTANCE.getAbilityBars()) {
                    return;
                }
                try {
                    if (!(abl instanceof AirDoorAbility) && DoaPassiveEvents.isInsideDoor((PlayerEntity)player)) {
                        return;
                    }
                    if (abl instanceof ChargeableAbility && abl.isCharging() && !((ChargeableAbility)abl).isCancelable()) {
                        return;
                    }
                    if (!(abl instanceof MorphAbility) || !abl.isContinuous()) {
                        // empty if block
                    }
                    abl.use((PlayerEntity)player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    abl.startCooldown((PlayerEntity)player);
                }
                player.field_70170_p.func_217381_Z().func_76319_b();
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

