/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability.components;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class CChangeAbilityAltModePacket {
    private int slot;

    public CChangeAbilityAltModePacket() {
    }

    public CChangeAbilityAltModePacket(int slot) {
        this.slot = slot;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
    }

    public static CChangeAbilityAltModePacket decode(PacketBuffer buffer) {
        CChangeAbilityAltModePacket msg = new CChangeAbilityAltModePacket();
        msg.slot = buffer.readInt();
        return msg;
    }

    public static void handle(CChangeAbilityAltModePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
                Ability abl = (Ability)abilityProps.getEquippedAbility(message.slot);
                if (abl == null || player.func_175149_v()) {
                    return;
                }
                AbilityUseResult result = abl.canUse((PlayerEntity)player);
                if (result.isFail()) {
                    if (result.getMessage() != null) {
                        player.func_145747_a(result.getMessage(), Util.field_240973_b_);
                    }
                    return;
                }
                abl.getComponent(ModAbilityKeys.ALT_MODE).ifPresent(arg_0 -> CChangeAbilityAltModePacket.lambda$null$0((PlayerEntity)player, arg_0));
            });
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(PlayerEntity player, AltModeComponent component) {
        if (component.isDisabled() || component.isAutomatic()) {
            return;
        }
        component.setNextInCycle((LivingEntity)player);
    }
}

