/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability.components;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class CSwingTriggerPacket {
    private int slot;

    public CSwingTriggerPacket() {
    }

    public CSwingTriggerPacket(LivingEntity entity, IAbility ability) {
        this.slot = AbilityDataCapability.get(entity).getEquippedAbilitySlot(ability);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.slot);
    }

    public static CSwingTriggerPacket decode(PacketBuffer buffer) {
        CSwingTriggerPacket msg = new CSwingTriggerPacket();
        msg.slot = buffer.readInt();
        return msg;
    }

    public static void handle(CSwingTriggerPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
                Ability abl = (Ability)abilityProps.getEquippedAbility(message.slot);
                if (abl == null || player.func_175149_v()) {
                    return;
                }
                abl.getComponent(ModAbilityKeys.SWING_TRIGGER).ifPresent(arg_0 -> CSwingTriggerPacket.lambda$null$0((PlayerEntity)player, arg_0));
            });
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(PlayerEntity player, SwingTriggerComponent component) {
        component.swing((LivingEntity)player);
    }
}

