/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.crew;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.events.CrewEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;

public class CCreateCrewPacket {
    private String name;

    public CCreateCrewPacket() {
    }

    public CCreateCrewPacket(String name) {
        this.name = name;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.name.length());
        buffer.func_180714_a(this.name);
    }

    public static CCreateCrewPacket decode(PacketBuffer buffer) {
        CCreateCrewPacket msg = new CCreateCrewPacket();
        int len = buffer.readInt();
        msg.name = buffer.func_150789_c(len);
        return msg;
    }

    public static void handle(CCreateCrewPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                boolean isAlreadyInCrew;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
                ExtendedWorldData worldProps = ExtendedWorldData.get();
                boolean hasSakeBottle = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().equals(ModItems.SAKE_BOTTLE.get());
                boolean bl = isAlreadyInCrew = worldProps.getCrewWithMember(player.func_110124_au()) != null;
                if (!hasSakeBottle || isAlreadyInCrew || !props.isPirate()) {
                    return;
                }
                Crew crew = new Crew(message.name, (LivingEntity)player);
                CrewEvent.Create event = new CrewEvent.Create((PlayerEntity)player, crew);
                if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                    worldProps.addCrew(crew);
                    crew.create(player.field_70170_p);
                    if (CommonConfig.INSTANCE.isCrewWorldMessageEnabled()) {
                        TranslationTextComponent newCrewMsg = new TranslationTextComponent(ModI18n.CREW_MESSAGE_NEW_CREW, new Object[]{message.name});
                        for (PlayerEntity target : player.field_70170_p.func_217369_A()) {
                            target.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + newCrewMsg.getString()), Util.field_240973_b_);
                        }
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

