/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.crew;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.events.CrewEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class CKickFromCrewPacket {
    private UUID uuid;

    public CKickFromCrewPacket() {
    }

    public CKickFromCrewPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.uuid);
    }

    public static CKickFromCrewPacket decode(PacketBuffer buffer) {
        CKickFromCrewPacket msg = new CKickFromCrewPacket();
        msg.uuid = buffer.func_179253_g();
        return msg;
    }

    public static void handle(CKickFromCrewPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                CrewEvent.Kick event;
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                UUID uuid = message.uuid;
                ExtendedWorldData worldData = ExtendedWorldData.get((IWorld)sender.field_70170_p);
                Crew crew = worldData.getCrewWithCaptain(sender.func_110124_au());
                PlayerEntity memberPlayer = sender.field_70170_p.func_217371_b(uuid);
                if (crew != null && crew.hasMember(uuid) && !MinecraftForge.EVENT_BUS.post((Event)(event = new CrewEvent.Kick(memberPlayer, crew)))) {
                    FactionHelper.sendMessageToCrew(sender.field_70170_p, crew, (ITextComponent)new TranslationTextComponent(ModI18n.CREW_MESSAGE_KICKED, new Object[]{crew.getMember(uuid).getUsername()}));
                    worldData.removeCrewMember(crew, uuid);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

