/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.entity;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdatePlayerMovementInput;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CSyncPlayerMovementInput {
    private float xxa;
    private float zza;

    public CSyncPlayerMovementInput() {
    }

    public CSyncPlayerMovementInput(float xxa, float zza) {
        this.xxa = xxa;
        this.zza = zza;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeFloat(this.xxa);
        buffer.writeFloat(this.zza);
    }

    public static CSyncPlayerMovementInput decode(PacketBuffer buffer) {
        CSyncPlayerMovementInput msg = new CSyncPlayerMovementInput();
        msg.xxa = buffer.readFloat();
        msg.zza = buffer.readFloat();
        return msg;
    }

    public static void handle(CSyncPlayerMovementInput message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                player.field_70702_br = message.xxa;
                player.field_191988_bg = message.zza;
                IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
                entityStatsProps.setXxa(player.field_70702_br);
                entityStatsProps.setZza(player.field_191988_bg);
                WyNetwork.sendToAllTrackingAndSelf(new SUpdatePlayerMovementInput((PlayerEntity)player), (LivingEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

