/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.quest;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CAbandonQuestPacket {
    private String questId;

    public CAbandonQuestPacket() {
    }

    public CAbandonQuestPacket(QuestId questId) {
        this.questId = questId.getRegistryName().toString();
    }

    public void encode(PacketBuffer buffer) {
        int len = this.questId.length();
        buffer.writeInt(len);
        buffer.func_211400_a(this.questId, len);
    }

    public static CAbandonQuestPacket decode(PacketBuffer buffer) {
        CAbandonQuestPacket msg = new CAbandonQuestPacket();
        int len = buffer.readInt();
        msg.questId = buffer.func_150789_c(len);
        return msg;
    }

    public static void handle(CAbandonQuestPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                if (Strings.isNullOrEmpty((String)message.questId)) {
                    return;
                }
                QuestId questId = (QuestId)GameRegistry.findRegistry(QuestId.class).getValue(new ResourceLocation(message.questId));
                if (questId == null) {
                    return;
                }
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IQuestData props = QuestDataCapability.get((PlayerEntity)player);
                QuestId current = props.getInProgressQuest(questId);
                props.removeInProgressQuest((Quest)((Object)current));
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

