/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ui;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenCharacterCreatorScreenPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenPlayerScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class COpenPlayerScreenPacket {
    public void encode(PacketBuffer buffer) {
    }

    public static COpenPlayerScreenPacket decode(PacketBuffer buffer) {
        COpenPlayerScreenPacket msg = new COpenPlayerScreenPacket();
        return msg;
    }

    public static void handle(COpenPlayerScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
                if (!(entityProps.hasRace() && entityProps.hasFaction() && entityProps.hasFightingStyle())) {
                    boolean hasRandomizedRace = CommonConfig.INSTANCE.getRaceRandomizer();
                    boolean allowMinkRaceSelect = CommonConfig.INSTANCE.getAllowMinkRaceSelect();
                    WyNetwork.sendTo(new SOpenCharacterCreatorScreenPacket(hasRandomizedRace, allowMinkRaceSelect), (PlayerEntity)player);
                } else {
                    IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
                    IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
                    IChallengesData challengeProps = ChallengesDataCapability.get((PlayerEntity)player);
                    ExtendedWorldData worldData = ExtendedWorldData.get();
                    boolean hasQuests = CommonConfig.INSTANCE.isQuestsEnabled();
                    int questAmount = questProps.countInProgressQuests();
                    boolean hasChallenges = CommonConfig.INSTANCE.isChallengesEnabled();
                    int challengeAmount = challengeProps.countChallenges();
                    boolean isInCombat = entityProps.isInCombatCache();
                    boolean isInChallengeDimension = WyHelper.isInChallengeDimension(player.field_70170_p);
                    int invites = challengeProps.getInvitations().size();
                    boolean hasCrew = worldData.getCrewWithMember(player.func_110124_au()) != null;
                    WyNetwork.sendTo(new SOpenPlayerScreenPacket(hasQuests, questAmount, hasChallenges, challengeAmount, isInCombat, isInChallengeDimension, invites, hasCrew), (PlayerEntity)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

