/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ui;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenChallengeGroupSelectorPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CScreenEventPacket {
    private static final TargetsPredicate TARGET_PICKER = new TargetsPredicate().testFriendlyFaction();
    private int eventId;

    public CScreenEventPacket(int eventId) {
        this.eventId = eventId;
    }

    public CScreenEventPacket() {
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.eventId);
    }

    public static CScreenEventPacket decode(PacketBuffer buffer) {
        CScreenEventPacket msg = new CScreenEventPacket();
        msg.eventId = buffer.readInt();
        return msg;
    }

    public static void handle(CScreenEventPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                switch (message.eventId) {
                    case 100: 
                    case 101: 
                    case 102: {
                        IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
                        List nearbyGroupMembers = TargetHelper.getEntitiesInArea((LivingEntity)player, 20.0, 20.0, 20.0, TARGET_PICKER, LivingEntity.class);
                        nearbyGroupMembers.removeIf(entity -> !(entity instanceof PlayerEntity));
                        nearbyGroupMembers.removeIf(entity -> {
                            for (UUID targetId : props.getGroupMembersIds()) {
                                if (targetId == null || !targetId.equals(entity.func_110124_au())) continue;
                                return true;
                            }
                            return false;
                        });
                        List<Integer> ids = nearbyGroupMembers.stream().map(e -> e.func_145782_y()).collect(Collectors.toList());
                        WyNetwork.sendTo(new SOpenChallengeGroupSelectorPacket(message.eventId, ids), (PlayerEntity)player);
                        break;
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

