/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class SLeashPlayerPacket {
    private UUID leashedId;
    private UUID leashHolderId;

    public SLeashPlayerPacket() {
    }

    public SLeashPlayerPacket(PlayerEntity leashedEntity, @Nullable PlayerEntity leashHolder) {
        this.leashedId = leashedEntity.func_110124_au();
        this.leashHolderId = leashHolder != null ? leashHolder.func_110124_au() : ModValues.NIL_UUID;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.leashedId);
        buffer.func_179252_a(this.leashHolderId);
    }

    public static SLeashPlayerPacket decode(PacketBuffer buffer) {
        SLeashPlayerPacket msg = new SLeashPlayerPacket();
        msg.leashedId = buffer.func_179253_g();
        msg.leashHolderId = buffer.func_179253_g();
        return msg;
    }

    public static void handle(SLeashPlayerPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SLeashPlayerPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            UUID leashHolderId = message.leashHolderId;
            UUID leashedId = message.leashedId;
            PlayerEntity leashedEntity = mc.field_71441_e.func_217371_b(leashedId);
            if (leashedEntity == null) {
                return;
            }
            IEntityStats props = EntityStatsCapability.get((LivingEntity)leashedEntity);
            if (!leashHolderId.equals(ModValues.NIL_UUID)) {
                PlayerEntity leashHolder = mc.field_71441_e.func_217371_b(message.leashHolderId);
                if (leashHolder == null) {
                    props.dropLeash();
                    return;
                }
                props.setLeashedTo((LivingEntity)leashHolder);
            } else {
                props.dropLeash();
            }
        }
    }
}

