/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSyncDynDimensionsPacket {
    private Set<RegistryKey<World>> addedDims;
    private Set<RegistryKey<World>> removedDims;

    public SSyncDynDimensionsPacket() {
    }

    public SSyncDynDimensionsPacket(Set<RegistryKey<World>> addedDims, Set<RegistryKey<World>> removedDims) {
        this.addedDims = addedDims;
        this.removedDims = removedDims;
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.addedDims.size());
        this.addedDims.forEach(key -> buf.func_192572_a(key.func_240901_a_()));
        buf.func_150787_b(this.removedDims.size());
        this.removedDims.forEach(key -> buf.func_192572_a(key.func_240901_a_()));
    }

    public static SSyncDynDimensionsPacket decode(PacketBuffer buf) {
        SSyncDynDimensionsPacket msg = new SSyncDynDimensionsPacket();
        HashSet<RegistryKey<World>> addedDims = new HashSet<RegistryKey<World>>();
        HashSet<RegistryKey<World>> removedDims = new HashSet<RegistryKey<World>>();
        int addedSize = buf.func_150792_a();
        for (int i = 0; i < addedSize; ++i) {
            ResourceLocation dim = buf.func_192575_l();
            addedDims.add(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim));
        }
        int removedSize = buf.func_150792_a();
        for (int i = 0; i < removedSize; ++i) {
            ResourceLocation dim = buf.func_192575_l();
            removedDims.add((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim));
        }
        msg.addedDims = addedDims;
        msg.removedDims = removedDims;
        return msg;
    }

    public static void handle(SSyncDynDimensionsPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSyncDynDimensionsPacket msg) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            Set levels = player.field_71174_a.func_239164_m_();
            levels.addAll(msg.addedDims);
            msg.removedDims.forEach(levels::remove);
        }
    }
}

