/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;
import xyz.pixelatedw.mineminenomi.data.entity.animation.AnimationDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.animation.IAnimationData;

public class SToggleAnimationPacket {
    private static final ResourceLocation EMPTY = new ResourceLocation("mineminenomi", "");
    private int entityId;
    private AnimationId<?> animId;
    private int duration;
    private int stateId;
    private boolean force;

    public SToggleAnimationPacket() {
    }

    public static SToggleAnimationPacket playAnimation(LivingEntity entity, AnimationId<?> animId, int duration, boolean force) {
        SToggleAnimationPacket packet = new SToggleAnimationPacket(entity, animId, AnimationComponent.State.PLAY, duration, force);
        return packet;
    }

    public static SToggleAnimationPacket stopAnimation(LivingEntity entity, AnimationId<?> animId) {
        SToggleAnimationPacket packet = new SToggleAnimationPacket(entity, animId, AnimationComponent.State.STOP, 0, false);
        return packet;
    }

    public SToggleAnimationPacket(LivingEntity entity, @Nullable AnimationId<?> animId, AnimationComponent.State state, int duration, boolean force) {
        this.entityId = entity.func_145782_y();
        this.animId = animId;
        this.duration = duration;
        this.stateId = state.ordinal();
        this.force = force;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.duration);
        buffer.func_192572_a(this.animId != null ? this.animId.getId() : EMPTY);
        buffer.writeInt(this.stateId);
        buffer.writeBoolean(this.force);
    }

    public static SToggleAnimationPacket decode(PacketBuffer buffer) {
        SToggleAnimationPacket msg = new SToggleAnimationPacket();
        msg.entityId = buffer.readInt();
        msg.duration = buffer.readInt();
        ResourceLocation animRes = buffer.func_192575_l();
        msg.animId = animRes.equals((Object)EMPTY) ? null : AnimationId.getRegisteredId(animRes);
        msg.stateId = buffer.readInt();
        msg.force = buffer.readBoolean();
        return msg;
    }

    public static void handle(SToggleAnimationPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SToggleAnimationPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientWorld world = mc.field_71441_e;
            Entity entity = world.func_73045_a(message.entityId);
            if (entity == null || !(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            IAnimationData animProps = AnimationDataCapability.get(living);
            AnimationComponent.State state = AnimationComponent.State.values()[message.stateId];
            if (state == AnimationComponent.State.PLAY) {
                animProps.startAnimation(message.animId, message.duration, message.force);
            } else if (state == AnimationComponent.State.STOP) {
                animProps.stopAnimation(message.animId);
            }
        }
    }
}

