/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.events.CombatModeEvents;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class SUpdateCombatStatePacket {
    private Optional<Integer> attackerId = Optional.empty();

    public SUpdateCombatStatePacket() {
    }

    public SUpdateCombatStatePacket(@Nullable LivingEntity attacker) {
        this.attackerId = attacker == null ? Optional.empty() : Optional.of(attacker.func_145782_y());
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.attackerId.isPresent());
        if (this.attackerId.isPresent()) {
            buffer.writeInt(this.attackerId.get().intValue());
        }
    }

    public static SUpdateCombatStatePacket decode(PacketBuffer buffer) {
        SUpdateCombatStatePacket msg = new SUpdateCombatStatePacket();
        boolean hasAttacker = buffer.readBoolean();
        msg.attackerId = Optional.empty();
        if (hasAttacker) {
            msg.attackerId = Optional.of(buffer.readInt());
        }
        return msg;
    }

    public static void handle(SUpdateCombatStatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateCombatStatePacket message) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            boolean hasAttacker = message.attackerId.isPresent();
            if (ClientConfig.INSTANCE.hasCombatUpdateChatMessageEnabled()) {
                player.func_145747_a(hasAttacker ? ModI18n.INFO_ENTERING_COMBAT : ModI18n.INFO_LEAVING_COMBAT, Util.field_240973_b_);
            }
            CombatModeEvents.Client.isInCombat = hasAttacker;
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            if (hasAttacker) {
                Entity attacker = player.field_70170_p.func_73045_a(((Integer)message.attackerId.get()).intValue());
                if (attacker != null && attacker instanceof LivingEntity) {
                    props.setInCombatCache((LivingEntity)attacker);
                }
            } else {
                props.setInCombatCache(null);
            }
        }
    }
}

