/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SSyncAbilityPacket {
    private int entityId;
    private ResourceLocation id;
    private CompoundNBT nbt;

    public SSyncAbilityPacket() {
    }

    public SSyncAbilityPacket(int entityId, IAbility abl) {
        this.entityId = entityId;
        this.id = abl.getCore().getRegistryName();
        this.nbt = abl.save(new CompoundNBT());
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_192572_a(this.id);
        buffer.func_150786_a(this.nbt);
    }

    public static SSyncAbilityPacket decode(PacketBuffer buffer) {
        SSyncAbilityPacket msg = new SSyncAbilityPacket();
        msg.entityId = buffer.readInt();
        msg.id = buffer.func_192575_l();
        msg.nbt = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SSyncAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSyncAbilityPacket message) {
            AbilityCore<?> core;
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)target;
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            Object abl = props.getEquippedOrPassiveAbility(core = AbilityCore.get(message.id));
            if (abl == null) {
                abl = AbilityCore.get(message.id).createAbility();
                props.addUnlockedAbility(core, AbilityUnlock.PROGRESSION);
            }
            abl.load(message.nbt);
        }
    }
}

