/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SUpdateAbilityIconPacket {
    private int entityId;
    private ResourceLocation abilityId;
    private ResourceLocation customTexture;

    public SUpdateAbilityIconPacket() {
    }

    public SUpdateAbilityIconPacket(PlayerEntity player, Ability abl) {
        this.entityId = player.func_145782_y();
        this.abilityId = abl.getCore().getRegistryName();
        this.customTexture = abl.getIcon(player);
    }

    public SUpdateAbilityIconPacket(PlayerEntity player, PassiveAbility2 abl) {
        this.entityId = player.func_145782_y();
        this.abilityId = abl.getCore().getRegistryName();
        this.customTexture = abl.getIcon((LivingEntity)player);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_192572_a(this.abilityId);
        buffer.func_192572_a(this.customTexture);
    }

    public static SUpdateAbilityIconPacket decode(PacketBuffer buffer) {
        SUpdateAbilityIconPacket msg = new SUpdateAbilityIconPacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.func_192575_l();
        msg.customTexture = buffer.func_192575_l();
        return msg;
    }

    public static void handle(SUpdateAbilityIconPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateAbilityIconPacket message) {
            AbilityCore core;
            if (message.abilityId == null) {
                return;
            }
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof PlayerEntity)) {
                return;
            }
            IAbilityData props = AbilityDataCapability.get((LivingEntity)target);
            Object ability = props.getEquippedOrPassiveAbility(core = (AbilityCore)ModRegistries.ABILITIES.getValue(message.abilityId));
            if (ability == null) {
                return;
            }
            if (ability instanceof Ability) {
                ((Ability)ability).setDisplayIcon(message.customTexture);
            } else if (ability instanceof PassiveAbility2) {
                ((PassiveAbility2)ability).setDisplayIcon(message.customTexture);
            }
        }
    }
}

