/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SUpdateEquippedAbilityPacket2 {
    private int entityId;
    private int abilityId;
    private CompoundNBT nbtData;

    public SUpdateEquippedAbilityPacket2() {
    }

    public SUpdateEquippedAbilityPacket2(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get(entity);
        this.entityId = entity.func_145782_y();
        this.abilityId = props.getEquippedAbilitySlot(ability);
        this.nbtData = ability.save(new CompoundNBT());
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.abilityId);
        buffer.func_150786_a(this.nbtData);
    }

    public static SUpdateEquippedAbilityPacket2 decode(PacketBuffer buffer) {
        SUpdateEquippedAbilityPacket2 msg = new SUpdateEquippedAbilityPacket2();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.readInt();
        msg.nbtData = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SUpdateEquippedAbilityPacket2 message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateEquippedAbilityPacket2 message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity) || message.abilityId < 0) {
                return;
            }
            IAbilityData props = AbilityDataCapability.get((LivingEntity)target);
            Object ability = props.getEquippedAbility(message.abilityId);
            if (ability == null) {
                return;
            }
            ability.load(message.nbtData);
        }
    }
}

