/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;

public class SUpdateHakiColorPacket {
    private int entityId;
    private int color;

    public SUpdateHakiColorPacket() {
    }

    public SUpdateHakiColorPacket(int entityId, int color) {
        this.entityId = entityId;
        this.color = color;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.color);
    }

    public static SUpdateHakiColorPacket decode(PacketBuffer buffer) {
        SUpdateHakiColorPacket msg = new SUpdateHakiColorPacket();
        msg.entityId = buffer.readInt();
        msg.color = buffer.readInt();
        return msg;
    }

    public static void handle(SUpdateHakiColorPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateHakiColorPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            IHakiData props = HakiDataCapability.get((LivingEntity)target);
            props.setHaoshokuHakiColour(message.color);
        }
    }
}

