/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.animations.Animation;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.animation.AnimationDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.animation.IAnimationData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SChangeAnimationStatePacket {
    private static final ResourceLocation EMPTY = new ResourceLocation("mineminenomi", "");
    private int entityId;
    private ResourceLocation abilityId;
    private int stateId;
    private int animDuration;
    private AnimationId<?> animId;

    public SChangeAnimationStatePacket() {
    }

    public SChangeAnimationStatePacket(LivingEntity entity, IAbility ability, AnimationId<?> animId, AnimationComponent.State state, int animDuration) {
        this.entityId = entity.func_145782_y();
        this.abilityId = ability.getCore().getRegistryName();
        this.animId = animId;
        this.animDuration = animDuration;
        this.stateId = state.ordinal();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_192572_a(this.abilityId);
        buffer.writeInt(this.stateId);
        buffer.writeInt(this.animDuration);
        buffer.func_192572_a(this.animId != null ? this.animId.getId() : EMPTY);
    }

    public static SChangeAnimationStatePacket decode(PacketBuffer buffer) {
        SChangeAnimationStatePacket msg = new SChangeAnimationStatePacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.func_192575_l();
        msg.stateId = buffer.readInt();
        msg.animDuration = buffer.readInt();
        ResourceLocation animRes = buffer.func_192575_l();
        msg.animId = animRes.equals((Object)EMPTY) ? null : AnimationId.getRegisteredId(animRes);
        return msg;
    }

    public static void handle(SChangeAnimationStatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SChangeAnimationStatePacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            AbilityCore<?> core = AbilityCore.get(message.abilityId);
            if (core == null) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IAnimationData animProps = AnimationDataCapability.get(entity);
            IAbilityData abilityProps = AbilityDataCapability.get(entity);
            Object abl = abilityProps.getEquippedAbility(core);
            if (abl == null && (abl = abilityProps.getPassiveAbility(core)) == null) {
                return;
            }
            AnimationComponent.State state = AnimationComponent.State.values()[message.stateId];
            abl.getComponent(ModAbilityKeys.ANIMATION).ifPresent(comp -> {
                if (state.equals((Object)AnimationComponent.State.PLAY) && message.animId != null && !message.animId.getId().equals((Object)EMPTY)) {
                    comp.start(entity, message.animId, message.animDuration);
                    if (comp.getAnimation() != null) {
                        ((Animation)comp.getAnimation()).start(entity, message.animDuration);
                        animProps.startAnimation(message.animId, message.animDuration, false);
                    }
                } else if (state.equals((Object)AnimationComponent.State.STOP)) {
                    comp.stop(entity);
                    if (comp.getAnimation() != null) {
                        ((Animation)comp.getAnimation()).stop(entity);
                        animProps.stopAnimation(message.animId);
                    }
                }
            });
        }
    }
}

