/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SStartDisablePacket {
    private int entityId;
    private int abilityId;
    private float disableTime;

    public SStartDisablePacket() {
    }

    public SStartDisablePacket(LivingEntity entity, IAbility ability, float disableTime) {
        this.entityId = entity.func_145782_y();
        this.abilityId = AbilityDataCapability.get(entity).getEquippedAbilitySlot(ability);
        this.disableTime = disableTime;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.abilityId);
        buffer.writeFloat(this.disableTime);
    }

    public static SStartDisablePacket decode(PacketBuffer buffer) {
        SStartDisablePacket msg = new SStartDisablePacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.readInt();
        msg.disableTime = buffer.readFloat();
        return msg;
    }

    public static void handle(SStartDisablePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SStartDisablePacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IAbilityData props = AbilityDataCapability.get(entity);
            Object abl = props.getEquippedAbility(message.abilityId);
            if (abl == null) {
                return;
            }
            abl.getComponent(ModAbilityKeys.DISABLE).ifPresent(c -> c.startDisable(entity, message.disableTime));
        }
    }
}

