/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.challenge;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.screens.ChallengesScreen;

public class SUpdateChallengeGroupPacket {
    private UUID memberId;
    private int groupSlot;

    public SUpdateChallengeGroupPacket() {
    }

    public SUpdateChallengeGroupPacket(UUID memberId, int groupSlot) {
        this.memberId = memberId;
        this.groupSlot = groupSlot;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.memberId);
        buffer.writeInt(this.groupSlot);
    }

    public static SUpdateChallengeGroupPacket decode(PacketBuffer buffer) {
        SUpdateChallengeGroupPacket msg = new SUpdateChallengeGroupPacket();
        msg.memberId = buffer.func_179253_g();
        msg.groupSlot = buffer.readInt();
        return msg;
    }

    public static void handle(SUpdateChallengeGroupPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateChallengeGroupPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            PlayerEntity member = mc.field_71441_e.func_217371_b(message.memberId);
            if (member == null) {
                return;
            }
            if (!(mc.field_71462_r instanceof ChallengesScreen)) {
                return;
            }
            ChallengesScreen screen = (ChallengesScreen)mc.field_71462_r;
            screen.setGroupMember(message.groupSlot, (LivingEntity)member);
        }
    }
}

