/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.entities;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class SUpdateColaAmountPacket {
    private int entityId;
    private int cola;
    private int maxCola;

    public SUpdateColaAmountPacket() {
    }

    public SUpdateColaAmountPacket(LivingEntity entity) {
        this.entityId = entity.func_145782_y();
        IEntityStats props = EntityStatsCapability.get(entity);
        this.cola = props.getCola();
        this.maxCola = props.getMaxCola();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.cola);
        buffer.writeInt(this.maxCola);
    }

    public static SUpdateColaAmountPacket decode(PacketBuffer buffer) {
        SUpdateColaAmountPacket msg = new SUpdateColaAmountPacket();
        msg.entityId = buffer.readInt();
        msg.cola = buffer.readInt();
        msg.maxCola = buffer.readInt();
        return msg;
    }

    public static void handle(SUpdateColaAmountPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateColaAmountPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IEntityStats props = EntityStatsCapability.get(entity);
            props.setCola(message.cola);
        }
    }
}

