/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.entities;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaHandsEntity;

public class SUpdateEntityOwnerPacket {
    private int entityId;
    private int ownerId;

    public SUpdateEntityOwnerPacket() {
    }

    public SUpdateEntityOwnerPacket(int entityId, int ownerId) {
        this.entityId = entityId;
        this.ownerId = ownerId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.ownerId);
    }

    public static SUpdateEntityOwnerPacket decode(PacketBuffer buffer) {
        SUpdateEntityOwnerPacket msg = new SUpdateEntityOwnerPacket();
        msg.entityId = buffer.readInt();
        msg.ownerId = buffer.readInt();
        return msg;
    }

    public static void handle(SUpdateEntityOwnerPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateEntityOwnerPacket message) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Entity entity = world.func_73045_a(message.entityId);
            if (entity == null || !(entity instanceof HanaHandsEntity)) {
                return;
            }
            HanaHandsEntity clutch = (HanaHandsEntity)entity;
            Entity owner = world.func_73045_a(message.ownerId);
            if (owner == null || !(owner instanceof LivingEntity)) {
                return;
            }
            clutch.setCaster((LivingEntity)owner);
        }
    }
}

