/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.entities;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class SUpdatePlayerMovementInput {
    private int entityId;
    private float xxa;
    private float zza;

    public SUpdatePlayerMovementInput() {
    }

    public SUpdatePlayerMovementInput(PlayerEntity player) {
        this.entityId = player.func_145782_y();
        this.xxa = player.field_70702_br;
        this.zza = player.field_191988_bg;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeFloat(this.xxa);
        buffer.writeFloat(this.zza);
    }

    public static SUpdatePlayerMovementInput decode(PacketBuffer buffer) {
        SUpdatePlayerMovementInput msg = new SUpdatePlayerMovementInput();
        msg.entityId = buffer.readInt();
        msg.xxa = buffer.readFloat();
        msg.zza = buffer.readFloat();
        return msg;
    }

    public static void handle(SUpdatePlayerMovementInput message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdatePlayerMovementInput message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)target;
            player.field_70702_br = message.xxa;
            player.field_191988_bg = message.zza;
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            entityStatsProps.setXxa(player.field_70702_br);
            entityStatsProps.setZza(player.field_191988_bg);
        }
    }
}

