/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.screens.PlayerStatsScreen;

public class SOpenPlayerScreenPacket {
    private boolean hasQuests;
    private int questAmount;
    private boolean hasChallenges;
    private int challengeAmount;
    private boolean isInCombat;
    private boolean isInChallengeDimension;
    private int invites;
    private boolean hasCrew;

    public SOpenPlayerScreenPacket() {
    }

    public SOpenPlayerScreenPacket(boolean hasQuests, int questAmount, boolean hasChallenges, int challengeAmount, boolean isInCombat, boolean isInChallengeDimension, int invites, boolean hasCrew) {
        this.hasQuests = hasQuests;
        this.questAmount = questAmount;
        this.hasChallenges = hasChallenges;
        this.challengeAmount = challengeAmount;
        this.isInCombat = isInCombat;
        this.isInChallengeDimension = isInChallengeDimension;
        this.invites = invites;
        this.hasCrew = hasCrew;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.hasQuests);
        buffer.writeInt(this.questAmount);
        buffer.writeBoolean(this.hasChallenges);
        buffer.writeInt(this.challengeAmount);
        buffer.writeBoolean(this.isInCombat);
        buffer.writeBoolean(this.isInChallengeDimension);
        buffer.writeInt(this.invites);
        buffer.writeBoolean(this.hasCrew);
    }

    public static SOpenPlayerScreenPacket decode(PacketBuffer buffer) {
        SOpenPlayerScreenPacket msg = new SOpenPlayerScreenPacket();
        msg.hasQuests = buffer.readBoolean();
        msg.questAmount = buffer.readInt();
        msg.hasChallenges = buffer.readBoolean();
        msg.challengeAmount = buffer.readInt();
        msg.isInCombat = buffer.readBoolean();
        msg.isInChallengeDimension = buffer.readBoolean();
        msg.invites = buffer.readInt();
        msg.hasCrew = buffer.readBoolean();
        return msg;
    }

    public static void handle(SOpenPlayerScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenPlayerScreenPacket message) {
            PlayerStatsScreen.open(message.hasQuests, message.questAmount, message.hasChallenges, message.challengeAmount, message.isInCombat, message.isInChallengeDimension, message.invites, message.hasCrew);
        }
    }
}

