/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ClientBossExtraInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class SUpdateOPBossInfoPacket {
    private UUID id;
    private int totalBars;
    private int activeBars;

    public SUpdateOPBossInfoPacket() {
    }

    public SUpdateOPBossInfoPacket(UUID id, int total, int active) {
        this.id = id;
        this.totalBars = total;
        this.activeBars = active;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.id);
        buffer.writeInt(this.totalBars);
        buffer.writeInt(this.activeBars);
    }

    public static SUpdateOPBossInfoPacket decode(PacketBuffer buffer) {
        SUpdateOPBossInfoPacket msg = new SUpdateOPBossInfoPacket();
        msg.id = buffer.func_179253_g();
        msg.totalBars = buffer.readInt();
        msg.activeBars = buffer.readInt();
        return msg;
    }

    public static void handle(SUpdateOPBossInfoPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateOPBossInfoPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            ClientBossExtraInfo extraInfo = new ClientBossExtraInfo();
            extraInfo.setTotalBars(message.totalBars);
            extraInfo.setActiveBars(message.activeBars);
            IEntityStats playerData = EntityStatsCapability.get((LivingEntity)player);
            playerData.addExtraBossInfo(message.id, extraInfo);
        }
    }
}

