/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3f;
import xyz.pixelatedw.mineminenomi.api.math.EasingDirection;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunction;

public class SimpleParticleData
extends ParticleType<SimpleParticleData>
implements IParticleData {
    public static final IParticleData.IDeserializer<SimpleParticleData> DESERIALIZER = new IParticleData.IDeserializer<SimpleParticleData>(){

        public SimpleParticleData fromCommand(ParticleType<SimpleParticleData> particleType, StringReader stringReader) throws CommandSyntaxException {
            SimpleParticleData part = (SimpleParticleData)particleType;
            part.setSize(2.0f);
            return part;
        }

        public SimpleParticleData fromNetwork(ParticleType<SimpleParticleData> particleType, PacketBuffer packetBuffer) {
            float red = packetBuffer.readFloat();
            float green = packetBuffer.readFloat();
            float blue = packetBuffer.readFloat();
            float alpha = packetBuffer.readFloat();
            float size = packetBuffer.readFloat();
            float rot = packetBuffer.readFloat();
            int life = packetBuffer.readInt();
            float yaw = packetBuffer.readFloat();
            float pitch = packetBuffer.readFloat();
            boolean hasMotionDecay = packetBuffer.readBoolean();
            boolean hasScaleDecay = packetBuffer.readBoolean();
            boolean faceCamera = packetBuffer.readBoolean();
            double motionX = packetBuffer.readDouble();
            double motionY = packetBuffer.readDouble();
            double motionZ = packetBuffer.readDouble();
            float rotX = packetBuffer.readFloat();
            float rotY = packetBuffer.readFloat();
            float rotZ = packetBuffer.readFloat();
            int animSpeed = packetBuffer.readInt();
            int easeFunc = packetBuffer.readInt();
            int easeDir = packetBuffer.readInt();
            float easeStr = packetBuffer.readFloat();
            SimpleParticleData data = new SimpleParticleData(particleType);
            data.setColor(red, green, blue, alpha);
            data.setMotion(motionX, motionY, motionZ);
            data.setRotation(rotX, rotY, rotZ);
            data.setSize(size);
            data.setRotationSpeed(rot);
            data.setLife(life);
            data.setLookVec(yaw, pitch);
            data.setHasMotionDecay(hasMotionDecay);
            data.setHasScaleDecay(hasScaleDecay);
            data.setAnimationSpeed(animSpeed);
            data.setFunction(easeFunc);
            data.setEaseDirection(easeDir);
            data.setEaseStrength(easeStr);
            return data;
        }
    };
    private final Codec<SimpleParticleData> codec = Codec.unit((Object)((Object)this));
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private double motionX;
    private double motionY;
    private double motionZ;
    private float rotX;
    private float rotY;
    private float rotZ;
    private float alpha = 1.0f;
    private float size = 1.0f;
    private float rotSpeed = 0.0f;
    private int life = 10;
    private boolean hasMotionDecay = true;
    private boolean hasScaleDecay = true;
    private boolean faceCamera = false;
    private float yaw;
    private float pitch;
    private int animSpeed = 2;
    private int function = -1;
    private int easeDirection;
    private float easeStrength = 1.0f;
    protected ParticleType type;

    public SimpleParticleData() {
        super(true, DESERIALIZER);
        this.type = this;
    }

    public SimpleParticleData(ParticleType type) {
        super(true, DESERIALIZER);
        this.type = type;
    }

    public SimpleParticleData(ParticleType type, IParticleData.IDeserializer des) {
        super(true, des);
        this.type = type;
    }

    public SimpleParticleData(boolean limiter, IParticleData.IDeserializer des) {
        super(limiter, des);
        this.type = this;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.alpha);
        buffer.writeFloat(this.size);
        buffer.writeFloat(this.rotSpeed);
        buffer.writeInt(this.life);
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
        buffer.writeBoolean(this.hasMotionDecay);
        buffer.writeBoolean(this.hasScaleDecay);
        buffer.writeBoolean(this.faceCamera);
        buffer.writeDouble(this.motionX);
        buffer.writeDouble(this.motionY);
        buffer.writeDouble(this.motionZ);
        buffer.writeFloat(this.rotX);
        buffer.writeFloat(this.rotY);
        buffer.writeFloat(this.rotZ);
        buffer.writeInt(this.animSpeed);
        buffer.writeInt(this.function);
        buffer.writeInt(this.easeDirection);
        buffer.writeFloat(this.easeStrength);
    }

    public void setLookVec(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.faceCamera = true;
    }

    public boolean faceCamera() {
        return this.faceCamera;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public SimpleParticleData setMotion(double motionX, double motionY, double motionZ) {
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        return this;
    }

    public SimpleParticleData setRotation(float rotX, float rotY, float rotZ) {
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
        this.rotSpeed = 0.3f;
        return this;
    }

    public void setAnimationSpeed(int speed) {
        this.animSpeed = speed;
    }

    public int getAnimationSpeed() {
        return this.animSpeed;
    }

    public void setEaseStrength(float val) {
        this.easeStrength = val;
    }

    public float getEaseStrength() {
        return this.easeStrength;
    }

    public void setEaseDirection(int id) {
        this.easeDirection = id;
    }

    public void setEaseDirection(EasingDirection dir) {
        this.easeDirection = dir.ordinal();
    }

    public EasingDirection getEaseDirecetion() {
        return EasingDirection.values()[this.easeDirection];
    }

    public void setFunction(int id) {
        this.function = id;
        this.setHasScaleDecay(false);
    }

    public void setFunction(EasingFunction func) {
        this.setFunction(func.ordinal());
    }

    public EasingFunction getFunction() {
        if (this.function < 0) {
            return null;
        }
        return EasingFunction.values()[this.function];
    }

    public SimpleParticleData setRotation(Vector3f vec) {
        return this.setRotation(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c());
    }

    public SimpleParticleData setColor(float red, float green, float blue) {
        return this.setColor(red, green, blue, 1.0f);
    }

    public SimpleParticleData setColor(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public SimpleParticleData setRotationSpeed(float rot) {
        this.rotSpeed = rot;
        return this;
    }

    public SimpleParticleData setSize(float size) {
        this.size = size;
        return this;
    }

    public SimpleParticleData setLife(int life) {
        this.life = life;
        return this;
    }

    public SimpleParticleData setHasMotionDecay(boolean flag) {
        this.hasMotionDecay = flag;
        return this;
    }

    public SimpleParticleData setHasScaleDecay(boolean flag) {
        this.hasScaleDecay = flag;
        return this;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getSize() {
        return this.size;
    }

    public float getRotationSpeed() {
        return this.rotSpeed;
    }

    public int getLife() {
        return this.life;
    }

    public double getDeltaMovementX() {
        return this.motionX;
    }

    public double getDeltaMovementY() {
        return this.motionY;
    }

    public double getDeltaMovementZ() {
        return this.motionZ;
    }

    public float getRotX() {
        return this.rotX;
    }

    public float getRotY() {
        return this.rotY;
    }

    public float getRotZ() {
        return this.rotZ;
    }

    public boolean hasMotionDecay() {
        return this.hasMotionDecay;
    }

    public boolean hasScaleDecay() {
        return this.hasScaleDecay;
    }

    public String func_197555_a() {
        return this.func_197554_b().getRegistryName().toString();
    }

    public ParticleType func_197554_b() {
        return this.type;
    }

    public Codec<SimpleParticleData> func_230522_e_() {
        return this.codec;
    }
}

