/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.haki;

import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HaoshokuHakiParticleEffect
extends ParticleEffect<Details> {
    public HaoshokuHakiParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        int size = details.size;
        int color = details.color;
        if (color == 0) {
            color = 0xFF0000;
        }
        BlockPos ogPos = new BlockPos(posX, posY, posZ);
        for (double x = (double)(-size); x < (double)size; x += 1.0) {
            for (double z = (double)(-size); z < (double)size; z += 1.0) {
                BlockState blockState;
                BlockPos pos = new BlockPos(posX + x, posY, posZ + z);
                if (!ogPos.func_218141_a((Vector3i)pos, (double)size) || ogPos.hashCode() % 20 < 5 || (blockState = world.func_180495_p(pos.func_177977_b())).func_185904_a() == Material.field_151579_a) continue;
                for (int i = 0; i < 10; ++i) {
                    world.func_195590_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), true, posX + WyHelper.randomWithRange(-3, 3) + x, posY, posZ + WyHelper.randomWithRange(-3, 3) + z, 0.0, 0.0, 0.0);
                }
            }
        }
        Vector3d playerPos = new Vector3d(posX, posY, posZ);
        double r = 2.0;
        for (double phi = 0.0; phi <= Math.PI * 2; phi += 0.04908738521234052) {
            double x = r * Math.cos(phi) + WyHelper.randomDouble() / 5.0;
            double z = r * Math.sin(phi) + WyHelper.randomDouble() / 5.0;
            Vector3d pos = playerPos.func_178787_e(new Vector3d(x, posY, z));
            Vector3d dirVec = playerPos.func_178788_d(pos).func_72432_b().func_216372_d(3.5, 1.0, 3.5);
            Color clientRGB = new Color(color);
            SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.CHIYU.get());
            data.setLife(15);
            data.setSize(3.0f);
            data.setMotion(-dirVec.field_72450_a, 0.0, -dirVec.field_72449_c);
            data.setColor((float)clientRGB.getRed() / 255.0f, (float)clientRGB.getGreen() / 255.0f, (float)clientRGB.getBlue() / 255.0f, 0.4f);
            world.func_195590_a((IParticleData)data, true, posX + x, posY + 0.3, posZ + z, 0.0, 0.0, 0.0);
            data = new SimpleParticleData((ParticleType)ModParticleTypes.CHIYU.get());
            data.setLife(15);
            data.setSize(2.0f);
            data.setMotion(-dirVec.field_72450_a, 0.0, -dirVec.field_72449_c);
            data.setColor(0.0f, 0.0f, 0.0f, 0.6f);
            world.func_195590_a((IParticleData)data, true, posX + x, posY + 0.3, posZ + z, 0.0, 0.0, 0.0);
        }
    }

    public static class Details
    extends ParticleEffect.Details {
        private int color;
        private int size;

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74768_a("color", this.color);
            nbt.func_74768_a("size", this.size);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.color = nbt.func_74762_e("color");
            this.size = nbt.func_74762_e("size");
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

