/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.suna;

import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SandBladeParticleEffect
extends ParticleEffect<ParticleEffect.NoDetails> {
    private boolean isActive = false;

    public SandBladeParticleEffect(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, ParticleEffect.NoDetails details) {
        int area = 7;
        for (int i = 0; i < 128; ++i) {
            double motionY = 0.0;
            if (this.isActive) {
                motionY = (WyHelper.randomWithRange(1, 10) + world.func_201674_k().nextDouble()) * 0.05;
            } else {
                motionY = WyHelper.randomDouble() / 30.0;
                area = 5;
            }
            posX += WyHelper.randomDouble() / (double)area;
            posZ += WyHelper.randomDouble() / (double)area;
            float particleSize = (world.func_201674_k().nextFloat() + 2.5f) / 2.0f;
            float color = WyHelper.colorTolerance(0.65f);
            SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.SUNA2.get());
            part.setMotion(0.0, motionY, 0.0);
            part.setColor(color, color, color);
            part.setLife(20);
            part.setRotation(0.0f, 0.0f, 1.0f);
            part.setSize(particleSize);
            world.func_195590_a((IParticleData)part, true, posX, posY + 0.2, posZ, 0.0, 0.0, 0.0);
        }
    }
}

