/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.yuki;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KamakuraParticleEffect
extends ParticleEffect<Details> {
    public KamakuraParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        int size = details.getSize();
        for (int i = 0; i < 60; ++i) {
            double offsetX = 2.0 * WyHelper.randomWithRange(-size, size) + WyHelper.randomDouble();
            double offsetY = 2.0 * WyHelper.randomWithRange(0, size) + WyHelper.randomDouble();
            double offsetZ = 2.0 * WyHelper.randomWithRange(-size, size) + WyHelper.randomDouble();
            double motionX = WyHelper.randomWithRange(-1, 1) + WyHelper.randomDouble();
            double motionZ = WyHelper.randomWithRange(-1, 1) + WyHelper.randomDouble();
            double middlePoint = 1.2;
            motionX *= middlePoint / 25.0;
            motionZ *= middlePoint / 25.0;
            float scale = (float)(1.0 + WyHelper.randomWithRange(5, 7));
            ParticleType particle = (ParticleType)ModParticleTypes.YUKI.get();
            particle = i % 5 == 0 ? (ParticleType)ModParticleTypes.YUKI3.get() : (i % 2 == 0 ? (ParticleType)ModParticleTypes.YUKI2.get() : (ParticleType)ModParticleTypes.YUKI.get());
            float rotation = world.func_201674_k().nextFloat() / 4.0f;
            SimpleParticleData part = new SimpleParticleData(particle);
            part.setLife(100);
            part.setSize(scale);
            part.setMotion(motionX, -0.05, motionZ);
            part.setRotation(0.0f, 0.0f, 1.0f);
            part.setRotationSpeed(rotation);
            part.setHasMotionDecay(false);
            world.func_195590_a((IParticleData)part, true, posX + offsetX, posY + offsetY, posZ + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static class Details
    extends ParticleEffect.Details {
        private int size;

        public Details() {
        }

        public Details(int size) {
            this.size = size;
        }

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74768_a("size", this.size);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.size = nbt.func_74762_e("size");
        }

        public int getSize() {
            return this.size;
        }
    }
}

