/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.abilities.TakedownKickAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;

public class TakedownTrialQuest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Takedown Kick", TakedownTrialQuest::new).build();
    private static final Predicate<ItemStack> IMPACT_DIAL_CHECK = itemStack -> itemStack.func_77973_b() == ((Block)ModBlocks.IMPACT_DIAL.get()).func_199767_j();
    private Objective objective01 = new ObtainItemObjective<Object>("Collect %s gunpowder", 32, () -> Items.field_151016_H);
    private Objective objective02 = new KillEntityObjective("Kill %s enemies using your fists while they're in air", 5, SharedKillChecks.HAS_EMPTY_HAND.and(SharedKillChecks.AIRBORNE_ENEMY_CHECK));
    private Objective objective03 = new ObtainItemObjective("Collect %s impact dials", 2, IMPACT_DIAL_CHECK);

    public TakedownTrialQuest(QuestId id) {
        super(id);
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_151016_H, 32)) {
            return false;
        }
        if (!this.removeQuestItem(player, ((Block)ModBlocks.IMPACT_DIAL.get()).func_199767_j(), 2)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(TakedownKickAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

