/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.artofweather;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderLanceTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderboltTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderstormTempo;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.TempoAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.UseAbilityObjective;

public class ArtOfWeatherTrial03Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Tempo Training", ArtOfWeatherTrial03Quest::new).addRequirements(ModQuests.ART_OF_WEATHER_TRIAL_02).build();
    private static final HashMap<UUID, List<IAbility>> USED_TEMPOS = new HashMap();
    private static final UseAbilityObjective.ICheckAbilityUse UNIQUE_TEMPO_CHECK = (player, ability) -> {
        if (ability instanceof TempoAbility) {
            List<IAbility> usedAbilities;
            if (!USED_TEMPOS.containsKey(player.func_110124_au())) {
                USED_TEMPOS.put(player.func_110124_au(), new ArrayList());
            }
            if (!(usedAbilities = USED_TEMPOS.get(player.func_110124_au())).contains(ability)) {
                usedAbilities.add(ability);
                return true;
            }
        }
        return false;
    };
    private static final KillEntityObjective.ICheckKill THUNDERBOLT_TEMPO_KILL_CHECK = (player, target, source) -> {
        if (source instanceof AbilityDamageSource) {
            return ((AbilityDamageSource)source).getAbilitySource().equals(ThunderboltTempo.INSTANCE);
        }
        return source.func_76355_l() == ModDamageSource.field_180137_b.func_76355_l();
    };
    private Objective objective01 = new ObtainItemObjective<ClimaTactItem>("Obtain a Perfect Clima Tact", 1, (Supplier<ClimaTactItem>)ModWeapons.PERFECT_CLIMA_TACT);
    private Objective objective02 = new UseAbilityObjective("Perform 3 unique Tempos", 3, UNIQUE_TEMPO_CHECK).addRequirement(this.objective01);
    private Objective objective03 = new KillEntityObjective("Kill %s enemies using Thunderbolt Tempo", 20, THUNDERBOLT_TEMPO_KILL_CHECK).addRequirement(this.objective01);

    public ArtOfWeatherTrial03Quest(QuestId id) {
        super(id);
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(ThunderstormTempo.INSTANCE, AbilityUnlock.PROGRESSION);
        props.addUnlockedAbility(ThunderLanceTempo.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

