/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.brawler;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;

public class BrawlerTrial04Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Hakai Ho", BrawlerTrial04Quest::new).addRequirements(ModQuests.BRAWLER_TRIAL_03).build();
    private static final Predicate<ItemStack> IMPACT_DIAL_CHECK = itemStack -> itemStack.func_77973_b() == ((Block)ModBlocks.IMPACT_DIAL.get()).func_199767_j();
    private static final KillEntityObjective.ICheckKill DISTANCE_CHECK = (player, target, source) -> {
        boolean isProj = source.func_76364_f() instanceof CannonBallProjectile;
        boolean hasDistance = player.func_70068_e((Entity)target) >= 900.0;
        return isProj && hasDistance;
    };
    private Objective objective01 = new ObtainItemObjective<Object>("Collect %s gunpowder", 30, () -> Items.field_151016_H);
    private Objective objective02 = new ObtainItemObjective("Collect %s impact dials", 5, IMPACT_DIAL_CHECK);
    private Objective objective03 = new KillEntityObjective("Kill %s enemies from at least 30 blocks away using Genkotsu Meteor", 5, SharedKillChecks.HAS_BRALWER_HAND_CHECK.and(DISTANCE_CHECK)).addRequirements(this.objective01, this.objective02);

    public BrawlerTrial04Quest(QuestId id) {
        super(id);
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_151016_H, 30)) {
            return false;
        }
        if (!this.removeQuestItem(player, ((Block)ModBlocks.IMPACT_DIAL.get()).func_199767_j(), 5)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(HakaiHoAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

