/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.doctor;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.abilities.doctor.FirstAidAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.quests.objectives.EquippedItemObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;

public class DoctorTrial01Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: First Aid", DoctorTrial01Quest::new).build();
    private Objective objective01 = new EquippedItemObjective("Equip a %s", 1, (Supplier<Item>)ModArmors.MEDIC_BAG, EquipmentSlotType.CHEST);
    private Objective objective02 = new ObtainItemObjective<Object>("Collect %s nether warts", 15, () -> Items.field_151075_bm).addRequirement(this.objective01);
    private Objective objective03 = new ObtainItemObjective<Object>("Collect %s glistering melon slices", 15, () -> Items.field_151060_bw).addRequirement(this.objective01);

    public DoctorTrial01Quest(QuestId id) {
        super(id);
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, Items.field_151075_bm, 15)) {
            return false;
        }
        if (!this.removeQuestItem(player, Items.field_151060_bw, 15)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(FirstAidAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

