/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArenaSkybox {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private float time;
    private int seed;
    private ResourceLocation texture;
    private int animationSpeed;

    public ArenaSkybox(ResourceLocation texture, int animationSpeed) {
        this.texture = texture;
        this.animationSpeed = animationSpeed;
    }

    public void renderSphere(MatrixStack matrixStack, float radius, int longs, int lats, float alpha) {
        BufferBuilder vertex = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        vertex.func_181668_a(4, DefaultVertexFormats.field_227852_q_);
        Matrix4f last = matrixStack.func_227866_c_().func_227870_a_();
        float startU = 0.0f;
        float startV = 0.0f;
        float endU = (float)Math.PI * 2;
        float endV = (float)Math.PI;
        float stepU = (endU - startU) / (float)longs;
        float stepV = (endV - startV) / (float)lats;
        float animU = (float)((Util.func_211177_b() + (long)this.seed) % (long)this.animationSpeed) / (float)this.animationSpeed;
        float animV = (float)(Util.func_211177_b() % (long)this.animationSpeed) / (float)this.animationSpeed;
        float uAnim = animU + 1.0f;
        float vAnim = 0.0f;
        for (int i = 0; i < longs; ++i) {
            for (int j = 0; j < lats; ++j) {
                float u = (float)i * stepU + startU;
                float v = (float)j * stepV + startV;
                float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                Vector3f p0 = this.parametricSphere(u, v, radius);
                Vector3f p1 = this.parametricSphere(u, vn, radius);
                Vector3f p2 = this.parametricSphere(un, v, radius);
                Vector3f p3 = this.parametricSphere(un, vn, radius);
                float textureU = u / endU * radius;
                float textureV = v / endV * radius;
                float textureUN = un / endU * radius;
                float textureVN = vn / endV * radius;
                this.vertexPosColorUVLight((IVertexBuilder)vertex, last, p0.func_195899_a(), p0.func_195900_b(), p0.func_195902_c(), 1.0f, 1.0f, 1.0f, alpha, textureU += uAnim, textureV, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, last, p2.func_195899_a(), p2.func_195900_b(), p2.func_195902_c(), 1.0f, 1.0f, 1.0f, alpha, textureUN += uAnim, textureV, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, last, p1.func_195899_a(), p1.func_195900_b(), p1.func_195902_c(), 1.0f, 1.0f, 1.0f, alpha, textureU, textureVN, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, last, p3.func_195899_a(), p3.func_195900_b(), p3.func_195902_c(), 1.0f, 1.0f, 1.0f, alpha, textureUN, textureVN, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, last, p1.func_195899_a(), p1.func_195900_b(), p1.func_195902_c(), 1.0f, 1.0f, 1.0f, alpha, textureU, textureVN, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, last, p2.func_195899_a(), p2.func_195900_b(), p2.func_195902_c(), 1.0f, 1.0f, 1.0f, alpha, textureUN, textureV, 1);
            }
        }
        vertex.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertex);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    private Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(MathHelper.func_76134_b((float)u) * MathHelper.func_76126_a((float)v) * r, MathHelper.func_76134_b((float)v) * r, MathHelper.func_76126_a((float)u) * MathHelper.func_76126_a((float)v) * r);
    }

    private void vertexPosColorUVLight(IVertexBuilder buffer, Matrix4f last, float x, float y, float z, float r, float g, float b, float a, float u, float v, int light) {
        buffer.func_227888_a_(last, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(light).func_181675_d();
    }
}

