/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.BottomHalfBodyEntity;

@OnlyIn(value=Dist.CLIENT)
public class BottomHalfBodyRenderer
extends EntityRenderer<BottomHalfBodyEntity> {
    private PlayerModel model = new PlayerModel(1.0f, false);

    public BottomHalfBodyRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(BottomHalfBodyEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, entity.field_70177_z + 180.0f, true));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (entity.field_70737_aN > 0) {
            matrixStack.func_227860_a_();
            RenderSystem.color3f((float)1.0f, (float)0.0f, (float)0.0f);
            matrixStack.func_227865_b_();
        }
        float headYawOffset = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
        float headYawRotation = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70758_at, (float)entity.field_70759_as);
        float netHeadYaw = headYawRotation - headYawOffset;
        float headPitch = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70127_C, (float)entity.field_70125_A);
        float f7 = (float)entity.field_70173_aa + partialTicks;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (entity.func_70089_S()) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_184618_aE, (float)entity.field_70721_aZ);
            limbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        ResourceLocation res = this.getTextureLocation(entity);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.model.func_228282_a_(res));
        this.model.field_217114_e = false;
        this.model.func_212843_a_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.func_225597_a_((LivingEntity)entity, limbSwing, limbSwingAmount, f7, netHeadYaw, headPitch);
        this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model.func_178719_a(false);
        this.model.field_178722_k.field_78806_j = true;
        this.model.field_178721_j.field_78806_j = true;
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(BottomHalfBodyEntity entity) {
        if (entity.getOwnerUUID() == null) {
            return DefaultPlayerSkin.func_177335_a();
        }
        PlayerEntity player = entity.field_70170_p.func_217371_b(entity.getOwnerUUID());
        if (player != null) {
            return ((AbstractClientPlayerEntity)player).func_110306_p();
        }
        return DefaultPlayerSkin.func_177334_a((UUID)entity.getOwnerUUID());
    }

    public static class Factory
    implements IRenderFactory<BottomHalfBodyEntity> {
        public EntityRenderer<? super BottomHalfBodyEntity> createRenderFor(EntityRendererManager manager) {
            return new BottomHalfBodyRenderer(manager);
        }
    }
}

