/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.VariProjectile;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.models.abilities.CubeModel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@OnlyIn(value=Dist.CLIENT)
public class VoltVariProjectileRenderer<T extends VariProjectile, M extends EntityModel<T>>
extends EntityRenderer<T> {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    protected M model;
    private ResourceLocation texture;
    Random random = new Random();

    public VoltVariProjectileRenderer(EntityRendererManager renderManager, M model) {
        super(renderManager);
        this.model = model;
    }

    public void setTexture(ResourceLocation res) {
        this.texture = res;
    }

    public void setColor(double red, double green, double blue, double alpha) {
        this.red = (float)(red / 255.0);
        this.green = (float)(green / 255.0);
        this.blue = (float)(blue / 255.0);
        this.alpha = (float)(alpha / 255.0);
    }

    public void setScale(double scaleX, double scaleY, double scaleZ) {
        this.scaleX = (float)scaleX;
        this.scaleY = (float)scaleY;
        this.scaleZ = (float)scaleZ;
    }

    public Vector3f getScale() {
        return new Vector3f(this.scaleX, this.scaleY, this.scaleZ);
    }

    public Color getRGB() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        RenderType type;
        if (((VariProjectile)entity).field_70173_aa < 2) {
            return;
        }
        this.setScale(entity.getSize(), entity.getSize(), entity.getSize());
        matrixStack.func_227860_a_();
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228657_l_());
        float randMovement = ((float)((VariProjectile)entity).field_70173_aa + partialTicks) / 600.0f;
        float rays = 1000.0f;
        matrixStack.func_227860_a_();
        int i = 0;
        while ((float)i < rays) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.random.nextFloat() * 360.0f + randMovement * 90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.random.nextFloat() * 360.0f + randMovement * 90.0f));
            float f3 = this.getScale().func_195899_a() / 3.0f * this.random.nextFloat();
            float f4 = this.getScale().func_195899_a() / 3.0f * this.random.nextFloat();
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            Color a = new Color(125, 249, 255, 80);
            Color b = new Color(125, 100, 255, 0);
            Color c = new Color(125, 255, 255, 0);
            RendererHelper.drawA(vertexBuilder, matrix4f, a);
            RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, b);
            RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, c);
            RendererHelper.drawA(vertexBuilder, matrix4f, a);
            RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, c);
            RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, c);
            RendererHelper.drawA(vertexBuilder, matrix4f, a);
            RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, c);
            RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, b);
            ++i;
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, ((VariProjectile)entity).field_70126_B + (((VariProjectile)entity).field_70177_z - ((VariProjectile)entity).field_70126_B) * partialTicks - 180.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, ((VariProjectile)entity).field_70127_C + (((VariProjectile)entity).field_70125_A - ((VariProjectile)entity).field_70127_C) * partialTicks, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        matrixStack.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
        ResourceLocation finalTexture = this.getTextureLocation(entity);
        RenderType renderType = type = finalTexture == null ? ModRenderTypes.TRANSPARENT_COLOR : RenderType.func_228644_e_((ResourceLocation)finalTexture);
        if (this.model != null) {
            this.model.func_225598_a_(matrixStack, buffer.getBuffer(type), packedLight, OverlayTexture.field_229196_a_, (float)this.getRGB().getRed() / 255.0f, (float)this.getRGB().getGreen() / 255.0f, (float)this.getRGB().getBlue() / 255.0f, (float)this.getRGB().getAlpha() / 255.0f);
        }
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (((AbilityProjectileEntity)((Object)entity)).getThrower() != null && ((AbilityProjectileEntity)((Object)entity)).isAffectedByHaki()) {
            boolean hardeningCheck;
            boolean bl = hardeningCheck = ((AbilityProjectileEntity)((Object)entity)).isAffectedByHardening() && HakiHelper.hasHardeningActive(((AbilityProjectileEntity)((Object)entity)).getThrower());
            if (hardeningCheck) {
                return ModResources.BUSOSHOKU_HAKI_ARM;
            }
        }
        return this.texture;
    }

    public static class Factory
    implements IRenderFactory<VariProjectile> {
        protected EntityModel model = new CubeModel();
        protected double scaleX = 1.0;
        protected double scaleY = 1.0;
        protected double scaleZ = 1.0;
        protected double red = 255.0;
        protected double green = 255.0;
        protected double blue = 255.0;
        protected double alpha = 255.0;
        protected ResourceLocation texture;

        public Factory(EntityModel model) {
            this.model = model;
        }

        public Factory setTexture(String textureName) {
            this.texture = new ResourceLocation("mineminenomi", "textures/models/projectiles/" + textureName + ".png");
            return this;
        }

        public Factory setTexture(ResourceLocation location) {
            this.texture = location;
            return this;
        }

        public Factory setColor(double red, double green, double blue, double alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            return this;
        }

        public Factory setColor(String hex) {
            Color color = WyHelper.hexToRGB(hex);
            this.red = color.getRed();
            this.green = color.getGreen();
            this.blue = color.getBlue();
            this.alpha = color.getAlpha();
            return this;
        }

        public Factory setAlpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Factory setScale(double scale) {
            this.scaleY = this.scaleZ = scale;
            this.scaleX = this.scaleZ;
            return this;
        }

        public Factory setScale(double scaleX, double scaleY, double scaleZ) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleZ = scaleZ;
            return this;
        }

        public EntityRenderer<? super VariProjectile> createRenderFor(EntityRendererManager manager) {
            VoltVariProjectileRenderer renderer = new VoltVariProjectileRenderer(manager, this.model);
            renderer.setTexture(this.texture);
            renderer.setScale(this.scaleX, this.scaleY, this.scaleZ);
            renderer.setColor(this.red, this.green, this.blue, this.alpha);
            return renderer;
        }
    }
}

