/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.blocks.FlagModel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FlagTileEntityRenderer
extends TileEntityRenderer<FlagTileEntity> {
    public static final ResourceLocation ON_FIRE_TEXTURE = new ResourceLocation("mineminenomi", "textures/misc/flagflame.png");
    private static final float[] SIZE_SCALE = new float[]{1.0f, 2.0f, 4.0f, 6.0f};
    private static final float[] OFFSET_X = new float[]{-0.5f, -0.75f, -0.87f, -0.916f};
    private static final float[] OFFSET_Y = new float[]{0.0f, -0.5f, -0.75f, -0.833f};
    private FlagModel flagModel = new FlagModel();

    public FlagTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FlagTileEntity blockEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (blockEntity.isSub()) {
            return;
        }
        World level = blockEntity.func_145831_w();
        UUID id = blockEntity.getOwnerUUID();
        PlayerEntity owner = level.func_217371_b(id);
        BlockState blockstate = blockEntity.func_195044_w();
        ExtendedWorldData worldData = ExtendedWorldData.get();
        int idx = ((CanvasSize)((Object)blockstate.func_177229_b(FlagBlock.SIZE))).ordinal();
        float scale = SIZE_SCALE[idx];
        Direction dir = ((Direction)blockstate.func_177229_b((Property)FlagBlock.FACING)).func_176734_d();
        BlockPos supportPos = blockEntity.func_174877_v().func_177982_a(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
        BlockState supportBlock = level.func_180495_p(supportPos);
        double supportOffset = 1.0 - supportBlock.func_196954_c((IBlockReader)level, supportPos).func_197758_c(dir.func_176740_k());
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, -((Direction)blockstate.func_177229_b((Property)FlagBlock.FACING)).func_185119_l() + 90.0f, true));
        matrixStack.func_227861_a_(supportOffset, 0.0, 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        matrixStack.func_227861_a_((double)OFFSET_X[idx], (double)OFFSET_Y[idx], 0.5);
        long flutterTick = level.func_82737_E() + (long)(((Object)((Object)blockEntity)).hashCode() / 100000);
        matrixStack.func_227860_a_();
        float flutterAnim = (float)(Math.cos((double)((float)flutterTick * 0.1f) + Math.PI) * (double)0.015f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.75, 0.96 - (double)flutterAnim, -0.55);
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227862_a_(0.9f, 0.9f, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(MathHelper.func_76134_b((float)((float)flutterTick * 0.12f + (float)Math.PI)) * 0.023f));
        RendererHelper.drawPlayerFactionIcon(blockEntity.getFaction(), (LivingEntity)owner, matrixStack, buffer, combinedLight);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.75, 0.96 - (double)flutterAnim, -0.47);
        matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
        matrixStack.func_227862_a_(0.9f, 0.9f, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229193_c_(MathHelper.func_76134_b((float)((float)flutterTick * 0.12f + (float)Math.PI)) * 0.02f));
        matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
        RendererHelper.drawPlayerFactionIcon(blockEntity.getFaction(), (LivingEntity)owner, matrixStack, buffer, combinedLight);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        RenderType renderType = ModRenderTypes.FLAG;
        Color backgroundColor = Color.BLACK;
        if (blockEntity.getFaction().equalsIgnoreCase("pirate")) {
            backgroundColor = Color.BLACK;
        } else if (blockEntity.getFaction().equalsIgnoreCase("marine") || blockEntity.getFaction().equalsIgnoreCase("world_government")) {
            backgroundColor = WyHelper.hexToRGB("#EAF5EC");
        } else if (blockEntity.getFaction().equalsIgnoreCase("revolutionary")) {
            backgroundColor = WyHelper.hexToRGB("#AE0000");
        }
        if (blockEntity.isOnFire()) {
            renderType = ModRenderTypes.FLAG_ON_FIRE;
            backgroundColor = Color.WHITE;
            if (blockEntity.getFaction().equalsIgnoreCase("pirate")) {
                backgroundColor = Color.GRAY;
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.25, 0.0, -0.6);
            this.renderFlame(matrixStack, buffer, 1.0f, 0.55f);
            matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            matrixStack.func_227861_a_(0.0, 0.0, 0.15);
            this.renderFlame(matrixStack, buffer, 1.0f, 0.55f);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, -0.51);
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(renderType);
        this.flagModel.flagAnimation(level, flutterTick);
        this.flagModel.func_225598_a_(matrixStack, ivertexbuilder, combinedLight, combinedOverlay, (float)backgroundColor.getRed() / 255.0f, (float)backgroundColor.getGreen() / 255.0f, (float)backgroundColor.getBlue() / 255.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public void renderFlame(MatrixStack matrixStack, IRenderTypeBuffer buffer, float width, float height) {
        TextureAtlasSprite fire0Atlas = ModelBakery.field_207763_a.func_229314_c_();
        TextureAtlasSprite fire1Atlas = ModelBakery.field_207764_b.func_229314_c_();
        matrixStack.func_227860_a_();
        float f = width * 1.4f;
        matrixStack.func_227862_a_(f, f, f);
        float f1 = 0.5f;
        float f3 = height / f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int i = 0;
        IVertexBuilder ivertexbuilder = buffer.getBuffer(Atlases.func_228783_h_());
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        while (f3 > 0.0f) {
            TextureAtlasSprite textureAtlas = i % 2 == 0 ? fire0Atlas : fire1Atlas;
            float f6 = textureAtlas.func_94209_e();
            float f7 = textureAtlas.func_94206_g();
            float f8 = textureAtlas.func_94212_f();
            float f9 = textureAtlas.func_94210_h();
            if (i / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            FlagTileEntityRenderer.fireVertex(matrixEntry, ivertexbuilder, f1 - 0.0f, 0.0f - f4, f5, f8, f9);
            FlagTileEntityRenderer.fireVertex(matrixEntry, ivertexbuilder, -f1 - 0.0f, 0.0f - f4, f5, f6, f9);
            FlagTileEntityRenderer.fireVertex(matrixEntry, ivertexbuilder, -f1 - 0.0f, 1.4f - f4, f5, f6, f7);
            FlagTileEntityRenderer.fireVertex(matrixEntry, ivertexbuilder, f1 - 0.0f, 1.4f - f4, f5, f8, f7);
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 += 0.03f;
            ++i;
        }
        matrixStack.func_227865_b_();
    }

    private static void fireVertex(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, float x, float y, float z, float texU, float texV) {
        buffer.func_227888_a_(matrixEntry.func_227870_a_(), x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(texU, texV).func_225585_a_(0, 10).func_227886_a_(240).func_227887_a_(matrixEntry.func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

