/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.mobs.IRandomTexture;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BindLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BodyCoatingLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.HandcuffsLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.PotionLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.abilities.HanaHandsLayer;

@OnlyIn(value=Dist.CLIENT)
public class HumanoidRenderer<T extends MobEntity, M extends BipedModel<T>>
extends BipedRenderer<T, M> {
    protected ResourceLocation texture;
    protected float[] scale;

    public HumanoidRenderer(EntityRendererManager manager, M model) {
        this(manager, model, null);
    }

    public HumanoidRenderer(EntityRendererManager manager, M model, String tex) {
        this(manager, model, new float[]{1.0f, 1.0f, 1.0f}, tex);
    }

    public HumanoidRenderer(EntityRendererManager manager, M model, float[] scale, @Nullable String tex) {
        super(manager, model, (float)(0.5 * Math.pow(scale[0], 1.5)));
        this.scale = scale;
        if (tex != null) {
            this.texture = new ResourceLocation("mineminenomi", "textures/models/" + tex + ".png");
        }
        this.func_177094_a(new BodyCoatingLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a(new PotionLayer((IEntityRenderer)this));
        this.func_177094_a(new AuraLayer(this));
        this.func_177094_a(new HandcuffsLayer((IEntityRenderer)this));
        this.func_177094_a(new BindLayer((IEntityRenderer)this));
        this.func_177094_a(new HanaHandsLayer((IEntityRenderer)this));
    }

    public void scale(T entity, MatrixStack matrixStack, float partialTickTime) {
        matrixStack.func_227862_a_(this.scale[0], this.scale[1], this.scale[2]);
    }

    public void func_225623_a_(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        boolean shouldSit;
        ((BipedModel)this.field_77045_g).func_178719_a(true);
        ((BipedModel)this.field_77045_g).field_178720_f.field_78806_j = false;
        ((BipedModel)this.field_77045_g).field_217113_d = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        ((BipedModel)this.field_77045_g).field_228270_o_ = entity.func_213453_ef();
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entityLiving, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_(entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks);
    }

    public ResourceLocation func_110775_a(T entity) {
        if (this.texture == null && entity instanceof IRandomTexture || this.texture.equals((Object)ModResources.NULL_ENTITY_TEXTURE)) {
            ResourceLocation texture = ((IRandomTexture)entity).getCurrentTexture();
            if (texture == null) {
                texture = ((IRandomTexture)entity).getDefaultTexture();
            }
            return texture;
        }
        return this.texture;
    }

    public static class Factory
    implements IRenderFactory {
        protected BipedModel model;
        private float[] scale;
        private String texture;

        public Factory(BipedModel model, float scale) {
            this(model, scale, scale, scale, null);
        }

        public Factory(BipedModel model, float scale, String texture) {
            this(model, scale, scale, scale, texture);
        }

        public Factory(BipedModel model, float scaleX, float scaleY, float scaleZ) {
            this(model, scaleX, scaleY, scaleZ, null);
        }

        public Factory(BipedModel model, float scaleX, float scaleY, float scaleZ, String texture) {
            this.model = model;
            this.texture = texture;
            this.scale = new float[]{scaleX, scaleY, scaleZ};
        }

        public EntityRenderer createRenderFor(EntityRendererManager manager) {
            return new HumanoidRenderer(manager, this.model, this.scale, this.texture);
        }
    }
}

