/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.renderers.entities.LightningEntityRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LightningBallEntityRenderer
extends EntityRenderer<LightningDischargeEntity> {
    public LightningBallEntityRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(LightningDischargeEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        List<LightningRendererPropieties> entities = entity.entities;
        if (!Minecraft.func_71410_x().func_147113_T()) {
            if (entity.field_70173_aa % entity.getUpdateRate() == 0) {
                entities.clear();
            }
            int lightnings = entity.getDensity();
            if (entities.isEmpty()) {
                for (int i = 0; i < lightnings; ++i) {
                    LightningRendererPropieties e2 = new LightningRendererPropieties(entity, entity.getSeed(), (float)WyHelper.randomWithRange(0, 360), (float)WyHelper.randomWithRange(0, 180), entity.getLightningLength());
                    entities.add(e2);
                }
            }
        }
        Color color = new Color(entity.getColor());
        float alpha = (float)entity.getAlpha() / 255.0f;
        Color outlineColor = new Color(entity.getOutlineColor());
        float outlineAlpha = (float)entity.getOutlineAlpha() / 255.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(entity.getSize() / 2.0f, entity.getSize() / 2.0f, entity.getSize() / 2.0f);
        entities.forEach(e -> LightningEntityRenderer.renderLightningDischarge(entity, e.random, e.length, e.xRot, e.yRot, color, alpha, outlineColor, outlineAlpha, matrixStack, bufferIn, packedLightIn));
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(LightningDischargeEntity entity) {
        return null;
    }

    public boolean shouldRender(LightningDischargeEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return true;
    }

    public static class Factory
    implements IRenderFactory<LightningDischargeEntity> {
        public EntityRenderer<? super LightningDischargeEntity> createRenderFor(EntityRendererManager manager) {
            return new LightningBallEntityRenderer(manager);
        }
    }

    public static class LightningRendererPropieties {
        private Entity entity = null;
        float xRot;
        float yRot;
        float length = 0.0f;
        long random = 0L;

        public LightningRendererPropieties(Entity entity, long random, float xRot, float yRot, float length) {
            this.entity = entity;
            this.random = random;
            this.yRot = yRot;
            this.xRot = xRot;
            this.length = length;
        }
    }
}

