/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.AbstractDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.WanderingDugongEntity;
import xyz.pixelatedw.mineminenomi.models.entities.mobs.animals.DugongModel;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BodyCoatingLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.PotionLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.WanderingDugongScarsLayer;

public class WanderingDugongRenderer<T extends WanderingDugongEntity, M extends DugongModel<T>>
extends MobRenderer<T, M> {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("mineminenomi", "textures/models/kung_fu_dugong.png");

    public WanderingDugongRenderer(EntityRendererManager manager) {
        super(manager, new DugongModel(), 0.4f);
        this.func_177094_a(new BodyCoatingLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this, 1.0f, 1.0f, 1.0f));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a(new PotionLayer((IEntityRenderer)this));
        this.func_177094_a(new AuraLayer(this));
        this.func_177094_a(new WanderingDugongScarsLayer(this));
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_(entity, matrixStack, ageInTicks, rotationYaw, partialTicks);
        if (((AbstractDugongEntity)entity).isTraining()) {
            switch (((AbstractDugongEntity)entity).getTrainingMode()) {
                case PUSHUPS: {
                    matrixStack.func_227861_a_(0.0, 0.25, 0.5);
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-75.0f));
                    break;
                }
                case SHADOW_BOXING: {
                    break;
                }
            }
        }
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return BASE_TEXTURE;
    }

    public static class Factory
    implements IRenderFactory {
        public EntityRenderer createRenderFor(EntityRendererManager manager) {
            return new WanderingDugongRenderer(manager);
        }
    }
}

